/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.query.BaseQuery;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.Result;
import org.apache.hive.druid.org.apache.druid.query.RetryQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.RetryQueryRunnerConfig;
import org.apache.hive.druid.org.apache.druid.query.SegmentDescriptor;
import org.apache.hive.druid.org.apache.druid.query.aggregation.LongSumAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.context.ConcurrentResponseContext;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.apache.hive.druid.org.apache.druid.query.spec.MultipleSpecificSegmentSpec;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesQuery;
import org.apache.hive.druid.org.apache.druid.query.timeseries.TimeseriesResultValue;
import org.apache.hive.druid.org.apache.druid.segment.SegmentMissingException;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.junit.Assert;
import org.junit.Test;

public class RetryQueryRunnerTest {
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
    final TimeseriesQuery query = Druids.newTimeseriesQueryBuilder().dataSource("testing").granularity(QueryRunnerTestHelper.DAY_GRAN).intervals(QueryRunnerTestHelper.FIRST_TO_THIRD).aggregators(Arrays.asList(QueryRunnerTestHelper.ROWS_COUNT, new LongSumAggregatorFactory("idx", "index"), QueryRunnerTestHelper.QUALITY_UNIQUES)).build();

    @Test
    public void testRunWithMissingSegments() {
        ConcurrentResponseContext context = ConcurrentResponseContext.createEmpty();
        context.put((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, new ArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus queryPlus, ResponseContext context) {
                context.add((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, Collections.singletonList(new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 1)));
                return Sequences.empty();
            }
        }, new RetryQueryRunnerConfig(){

            public int getNumTries() {
                return 0;
            }

            public boolean isReturnPartialResults() {
                return true;
            }
        }, this.jsonMapper);
        List actualResults = runner.run(QueryPlus.wrap((Query)this.query), (ResponseContext)context).toList();
        Assert.assertTrue((String)"Should have one entry in the list of missing segments", (((List)context.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS)).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should return an empty sequence as a result", (actualResults.size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRetry() {
        ConcurrentResponseContext context = ConcurrentResponseContext.createEmpty();
        context.put((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)0);
        context.put((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, new ArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, ResponseContext context) {
                if ((Integer)context.get((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS) == 0) {
                    context.add((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, Collections.singletonList(new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 1)));
                    context.put((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)1);
                    return Sequences.empty();
                }
                return Sequences.simple(Collections.singletonList(new Result(DateTimes.nowUtc(), (Object)new TimeseriesResultValue(new HashMap()))));
            }
        }, (RetryQueryRunnerConfig)new TestRetryQueryRunnerConfig(1, true), this.jsonMapper);
        List actualResults = runner.run(QueryPlus.wrap((Query)this.query), (ResponseContext)context).toList();
        Assert.assertTrue((String)"Should return a list with one element", (actualResults.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have nothing in missingSegment list", (((List)context.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS)).size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRetryMultiple() {
        ConcurrentResponseContext context = ConcurrentResponseContext.createEmpty();
        context.put((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)0);
        context.put((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, new ArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, ResponseContext context) {
                if ((Integer)context.get((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS) < 3) {
                    context.add((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, Collections.singletonList(new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 1)));
                    context.put((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)((Integer)context.get((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS) + 1));
                    return Sequences.empty();
                }
                return Sequences.simple(Collections.singletonList(new Result(DateTimes.nowUtc(), (Object)new TimeseriesResultValue(new HashMap()))));
            }
        }, (RetryQueryRunnerConfig)new TestRetryQueryRunnerConfig(4, true), this.jsonMapper);
        List actualResults = runner.run(QueryPlus.wrap((Query)this.query), (ResponseContext)context).toList();
        Assert.assertTrue((String)"Should return a list with one element", (actualResults.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have nothing in missingSegment list", (((List)context.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS)).size() == 0 ? 1 : 0) != 0);
    }

    @Test(expected=SegmentMissingException.class)
    public void testException() {
        ConcurrentResponseContext context = ConcurrentResponseContext.createEmpty();
        context.put((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, new ArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, ResponseContext context) {
                context.add((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, Collections.singletonList(new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 1)));
                return Sequences.empty();
            }
        }, (RetryQueryRunnerConfig)new TestRetryQueryRunnerConfig(1, false), this.jsonMapper);
        runner.run(QueryPlus.wrap((Query)this.query), (ResponseContext)context).toList();
        Assert.assertTrue((String)"Should have one entry in the list of missing segments", (((List)context.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS)).size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testNoDuplicateRetry() {
        ConcurrentResponseContext context = ConcurrentResponseContext.createEmpty();
        context.put((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)0);
        context.put((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, new ArrayList());
        RetryQueryRunner runner = new RetryQueryRunner((QueryRunner)new QueryRunner<Result<TimeseriesResultValue>>(){

            public Sequence<Result<TimeseriesResultValue>> run(QueryPlus<Result<TimeseriesResultValue>> queryPlus, ResponseContext context) {
                Query query = queryPlus.getQuery();
                if ((Integer)context.get((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS) == 0) {
                    context.add((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, Arrays.asList(new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 1), new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 2)));
                    context.put((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)1);
                    return Sequences.simple(Collections.singletonList(new Result(DateTimes.nowUtc(), (Object)new TimeseriesResultValue(new HashMap()))));
                }
                if ((Integer)context.get((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS) == 1) {
                    Assert.assertTrue((String)"Should retry with 2 missing segments", (((MultipleSpecificSegmentSpec)((BaseQuery)query).getQuerySegmentSpec()).getDescriptors().size() == 2 ? 1 : 0) != 0);
                    context.add((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS, Collections.singletonList(new SegmentDescriptor(Intervals.utc((long)178888L, (long)1999999L), "test", 2)));
                    context.put((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)2);
                    return Sequences.simple(Collections.singletonList(new Result(DateTimes.nowUtc(), (Object)new TimeseriesResultValue(new HashMap()))));
                }
                Assert.assertTrue((String)"Should retry with 1 missing segments", (((MultipleSpecificSegmentSpec)((BaseQuery)query).getQuerySegmentSpec()).getDescriptors().size() == 1 ? 1 : 0) != 0);
                context.put((ResponseContext.BaseKey)ResponseContext.Key.NUM_SCANNED_ROWS, (Object)3);
                return Sequences.simple(Collections.singletonList(new Result(DateTimes.nowUtc(), (Object)new TimeseriesResultValue(new HashMap()))));
            }
        }, (RetryQueryRunnerConfig)new TestRetryQueryRunnerConfig(2, false), this.jsonMapper);
        List actualResults = runner.run(QueryPlus.wrap((Query)this.query), (ResponseContext)context).toList();
        Assert.assertTrue((String)"Should return a list with 3 elements", (actualResults.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Should have nothing in missingSegment list", (((List)context.get((ResponseContext.BaseKey)ResponseContext.Key.MISSING_SEGMENTS)).size() == 0 ? 1 : 0) != 0);
    }

    private static class TestRetryQueryRunnerConfig
    extends RetryQueryRunnerConfig {
        private int numTries;
        private boolean returnPartialResults;

        public TestRetryQueryRunnerConfig(int numTries, boolean returnPartialResults) {
            this.numTries = numTries;
            this.returnPartialResults = returnPartialResults;
        }

        public int getNumTries() {
            return this.numTries;
        }

        public boolean isReturnPartialResults() {
            return this.returnPartialResults;
        }
    }
}

