/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.query;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.query.AsyncQueryRunner;
import org.apache.hive.druid.org.apache.druid.query.Druids;
import org.apache.hive.druid.org.apache.druid.query.Query;
import org.apache.hive.druid.org.apache.druid.query.QueryPlus;
import org.apache.hive.druid.org.apache.druid.query.QueryRunner;
import org.apache.hive.druid.org.apache.druid.query.QueryRunnerTestHelper;
import org.apache.hive.druid.org.apache.druid.query.QueryWatcher;
import org.apache.hive.druid.org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.hive.druid.org.apache.druid.query.context.ResponseContext;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class AsyncQueryRunnerTest {
    private static final long TEST_TIMEOUT_MILLIS = 60000L;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Query query = Druids.newTimeseriesQueryBuilder().dataSource("test").intervals("2014/2015").aggregators(Collections.singletonList(new CountAggregatorFactory("count"))).build();

    @Test(timeout=60000L)
    public void testAsyncNature() {
        final CountDownLatch latch = new CountDownLatch(1);
        QueryRunner baseRunner = new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
                try {
                    latch.await();
                    return Sequences.simple(Collections.singletonList(1));
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        AsyncQueryRunner asyncRunner = new AsyncQueryRunner(baseRunner, this.executor, QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        Sequence lazy = asyncRunner.run(QueryPlus.wrap((Query)this.query));
        latch.countDown();
        Assert.assertEquals(Collections.singletonList(1), (Object)lazy.toList());
    }

    @Test(timeout=60000L)
    public void testQueryTimeoutHonored() {
        QueryRunner baseRunner = new QueryRunner(){

            public Sequence run(QueryPlus queryPlus, ResponseContext responseContext) {
                try {
                    Thread.sleep(Long.MAX_VALUE);
                    throw new RuntimeException("query should not have completed");
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        AsyncQueryRunner asyncRunner = new AsyncQueryRunner(baseRunner, this.executor, QueryRunnerTestHelper.NOOP_QUERYWATCHER);
        Sequence lazy = asyncRunner.run(QueryPlus.wrap((Query)this.query.withOverriddenContext((Map)ImmutableMap.of((Object)"timeout", (Object)1))));
        try {
            lazy.toList();
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof TimeoutException));
            return;
        }
        Assert.fail();
    }

    @Test
    public void testQueryRegistration() {
        QueryRunner baseRunner = (queryPlus, responseContext) -> null;
        QueryWatcher mock = (QueryWatcher)EasyMock.createMock(QueryWatcher.class);
        mock.registerQuery((Query)EasyMock.eq((Object)this.query), (ListenableFuture)EasyMock.anyObject(ListenableFuture.class));
        EasyMock.replay((Object[])new Object[]{mock});
        AsyncQueryRunner asyncRunner = new AsyncQueryRunner(baseRunner, this.executor, mock);
        asyncRunner.run(QueryPlus.wrap((Query)this.query));
        EasyMock.verify((Object[])new Object[]{mock});
    }
}

