/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.metadata;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataSegmentManagerConfig;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataSegmentManager;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataSegmentPublisher;
import org.apache.hive.druid.org.apache.druid.metadata.TestDerbyConnector;
import org.apache.hive.druid.org.apache.druid.metadata.UnknownSegmentIdException;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.apache.hive.druid.org.apache.druid.server.metrics.NoopServiceEmitter;
import org.apache.hive.druid.org.apache.druid.timeline.DataSegment;
import org.apache.hive.druid.org.apache.druid.timeline.partition.NoneShardSpec;
import org.apache.hive.druid.org.apache.druid.timeline.partition.ShardSpec;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SQLMetadataSegmentManagerTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private SQLMetadataSegmentManager sqlSegmentsMetadata;
    private SQLMetadataSegmentPublisher publisher;
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();
    private final DataSegment segment1 = SQLMetadataSegmentManagerTest.createSegment("wikipedia", "2012-03-15T00:00:00.000/2012-03-16T00:00:00.000", "2012-03-16T00:36:30.848Z", "index/y=2012/m=03/d=15/2012-03-16T00:36:30.848Z/0/index.zip", 0);
    private final DataSegment segment2 = SQLMetadataSegmentManagerTest.createSegment("wikipedia", "2012-01-05T00:00:00.000/2012-01-06T00:00:00.000", "2012-01-06T22:19:12.565Z", "wikipedia/index/y=2012/m=01/d=05/2012-01-06T22:19:12.565Z/0/index.zip", 0);

    private static DataSegment createSegment(String dataSource, String interval, String version, String bucketKey, int binaryVersion) {
        return new DataSegment(dataSource, Intervals.of((String)interval), version, (Map)ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)"test", (Object)"key", (Object)(dataSource + "/" + bucketKey)), (List)ImmutableList.of((Object)"dim1", (Object)"dim2", (Object)"dim3"), (List)ImmutableList.of((Object)"count", (Object)"value"), (ShardSpec)NoneShardSpec.instance(), Integer.valueOf(binaryVersion), 1234L);
    }

    private void publish(DataSegment segment, boolean used) throws IOException {
        boolean partitioned = !(segment.getShardSpec() instanceof NoneShardSpec);
        this.publisher.publishSegment(segment.getId().toString(), segment.getDataSource(), DateTimes.nowUtc().toString(), segment.getInterval().getStart().toString(), segment.getInterval().getEnd().toString(), partitioned, segment.getVersion(), used, this.jsonMapper.writeValueAsBytes((Object)segment));
    }

    @Before
    public void setUp() throws Exception {
        TestDerbyConnector connector = this.derbyConnectorRule.getConnector();
        MetadataSegmentManagerConfig config = new MetadataSegmentManagerConfig();
        config.setPollDuration(Period.seconds((int)1));
        this.sqlSegmentsMetadata = new SQLMetadataSegmentManager(this.jsonMapper, Suppliers.ofInstance((Object)config), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)connector);
        this.sqlSegmentsMetadata.start();
        this.publisher = new SQLMetadataSegmentPublisher(this.jsonMapper, (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get(), (SQLMetadataConnector)connector);
        connector.createSegmentTable();
        this.publisher.publishSegment(this.segment1);
        this.publisher.publishSegment(this.segment2);
    }

    @After
    public void teardown() {
        if (this.sqlSegmentsMetadata.isPollingDatabasePeriodically()) {
            this.sqlSegmentsMetadata.stopPollingDatabasePeriodically();
        }
        this.sqlSegmentsMetadata.stop();
    }

    @Test
    public void testPoll() {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"wikipedia"), (Object)this.sqlSegmentsMetadata.retrieveAllDataSourceNames());
        Assert.assertEquals((Object)ImmutableList.of((Object)"wikipedia"), this.sqlSegmentsMetadata.getImmutableDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Collection)this.sqlSegmentsMetadata.getImmutableDataSourceWithUsedSegments("wikipedia").getSegments()));
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
    }

    @Test
    public void testPrepareImmutableDataSourceWithUsedSegmentsAwaitsPollOnRestart() throws IOException {
        DataSegment newSegment = this.pollThenStopThenStartIntro();
        Assert.assertEquals((Object)ImmutableSet.of((Object)newSegment), (Object)ImmutableSet.copyOf((Collection)this.sqlSegmentsMetadata.getImmutableDataSourceWithUsedSegments("wikipedia2").getSegments()));
    }

    @Test
    public void testGetDataSourceWithUsedSegmentsAwaitsPollOnRestart() throws IOException {
        DataSegment newSegment = this.pollThenStopThenStartIntro();
        Assert.assertEquals((Object)ImmutableSet.of((Object)newSegment), (Object)ImmutableSet.copyOf((Collection)this.sqlSegmentsMetadata.getImmutableDataSourceWithUsedSegments("wikipedia2").getSegments()));
    }

    @Test
    public void testPrepareImmutableDataSourcesWithAllUsedSegmentsAwaitsPollOnRestart() throws IOException {
        DataSegment newSegment = this.pollThenStopThenStartIntro();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment), (Object)ImmutableSet.copyOf(this.sqlSegmentsMetadata.getImmutableDataSourcesWithAllUsedSegments().stream().flatMap(dataSource -> dataSource.getSegments().stream()).iterator()));
    }

    @Test
    public void testIterateAllUsedSegmentsAwaitsPollOnRestart() throws IOException {
        DataSegment newSegment = this.pollThenStopThenStartIntro();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
    }

    private DataSegment pollThenStopThenStartIntro() throws IOException {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        this.sqlSegmentsMetadata.stopPollingDatabasePeriodically();
        Assert.assertFalse((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        Assert.assertEquals((Object)ImmutableSet.of((Object)"wikipedia"), (Object)this.sqlSegmentsMetadata.retrieveAllDataSourceNames());
        DataSegment newSegment = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        this.publisher.publishSegment(newSegment);
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        return newSegment;
    }

    @Test
    public void testPollWithCorruptedSegment() {
        this.publisher.publishSegment("corrupt-segment-id", "corrupt-datasource", "corrupt-create-date", "corrupt-start-date", "corrupt-end-date", true, "corrupt-version", true, StringUtils.toUtf8((String)"corrupt-payload"));
        EmittingLogger.registerEmitter((ServiceEmitter)new NoopServiceEmitter());
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        Assert.assertEquals((Object)"wikipedia", (Object)((ImmutableDruidDataSource)Iterables.getOnlyElement((Iterable)this.sqlSegmentsMetadata.getImmutableDataSourcesWithAllUsedSegments())).getName());
    }

    @Test
    public void testGetUnusedSegmentIntervals() {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        int numChangedSegments = this.sqlSegmentsMetadata.markAsUnusedAllSegmentsInDataSource("wikipedia");
        Assert.assertEquals((long)2L, (long)numChangedSegments);
        Assert.assertEquals((Object)ImmutableList.of((Object)this.segment2.getInterval()), (Object)this.sqlSegmentsMetadata.getUnusedSegmentIntervals("wikipedia", DateTimes.of((String)"3000"), 1));
        Assert.assertEquals((Object)ImmutableList.of((Object)this.segment2.getInterval(), (Object)this.segment1.getInterval()), (Object)this.sqlSegmentsMetadata.getUnusedSegmentIntervals("wikipedia", DateTimes.of((String)"3000"), 5));
    }

    @Test(timeout=60000L)
    public void testMarkAsUnusedAllSegmentsInDataSource() throws IOException, InterruptedException {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        this.publisher.publishSegment(newSegment);
        this.awaitDataSourceAppeared("wikipedia2");
        int numChangedSegments = this.sqlSegmentsMetadata.markAsUnusedAllSegmentsInDataSource("wikipedia2");
        Assert.assertEquals((long)1L, (long)numChangedSegments);
        this.awaitDataSourceDisappeared("wikipedia2");
        Assert.assertNull((Object)this.sqlSegmentsMetadata.getImmutableDataSourceWithUsedSegments("wikipedia2"));
    }

    private static DataSegment createNewSegment1(String newDataSource) {
        return SQLMetadataSegmentManagerTest.createSegment(newDataSource, "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
    }

    private static DataSegment createNewSegment2(String newDataSource) {
        return SQLMetadataSegmentManagerTest.createSegment(newDataSource, "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
    }

    @Test(timeout=60000L)
    public void testMarkSegmentAsUnused() throws IOException, InterruptedException {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment = SQLMetadataSegmentManagerTest.createSegment("wikipedia2", "2017-10-15T00:00:00.000/2017-10-16T00:00:00.000", "2017-10-15T20:19:12.565Z", "wikipedia2/index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        this.publisher.publishSegment(newSegment);
        this.awaitDataSourceAppeared("wikipedia2");
        Assert.assertNotNull((Object)this.sqlSegmentsMetadata.getImmutableDataSourceWithUsedSegments("wikipedia2"));
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.markSegmentAsUnused(newSegment.getId().toString()));
        this.awaitDataSourceDisappeared("wikipedia2");
        Assert.assertNull((Object)this.sqlSegmentsMetadata.getImmutableDataSourceWithUsedSegments("wikipedia2"));
    }

    private void awaitDataSourceAppeared(String newDataSource) throws InterruptedException {
        while (this.sqlSegmentsMetadata.getImmutableDataSourceWithUsedSegments(newDataSource) == null) {
            Thread.sleep(1000L);
        }
    }

    private void awaitDataSourceDisappeared(String dataSource) throws InterruptedException {
        while (this.sqlSegmentsMetadata.getImmutableDataSourceWithUsedSegments(dataSource) != null) {
            Thread.sleep(1000L);
        }
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegments() throws Exception {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SQLMetadataSegmentManagerTest.createSegment("wikipedia2", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        DataSegment newSegment2 = SQLMetadataSegmentManagerTest.createSegment("wikipedia2", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 1);
        DataSegment newSegment3 = SQLMetadataSegmentManagerTest.createSegment("wikipedia2", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 1);
        this.publish(newSegment1, false);
        this.publish(newSegment2, false);
        this.publish(newSegment3, false);
        ImmutableSet segmentIds = ImmutableSet.of((Object)newSegment1.getId().toString(), (Object)newSegment2.getId().toString(), (Object)newSegment3.getId().toString());
        this.sqlSegmentsMetadata.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
        Assert.assertEquals((long)2L, (long)this.sqlSegmentsMetadata.markAsUsedNonOvershadowedSegments("wikipedia2", (Set)segmentIds));
        this.sqlSegmentsMetadata.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment1, (Object)newSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
    }

    @Test(expected=UnknownSegmentIdException.class)
    public void testMarkAsUsedNonOvershadowedSegmentsInvalidDataSource() throws Exception {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        this.publish(newSegment1, false);
        this.publish(newSegment2, false);
        ImmutableSet segmentIds = ImmutableSet.of((Object)newSegment1.getId().toString(), (Object)newSegment2.getId().toString());
        this.sqlSegmentsMetadata.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
        Assert.assertEquals((long)0L, (long)this.sqlSegmentsMetadata.markAsUsedNonOvershadowedSegments("wrongDataSource", (Set)segmentIds));
    }

    @Test(expected=UnknownSegmentIdException.class)
    public void testMarkAsUsedNonOvershadowedSegmentsWithInvalidSegmentIds() throws UnknownSegmentIdException {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        ImmutableSet segmentIds = ImmutableSet.of((Object)newSegment1.getId().toString(), (Object)newSegment2.getId().toString());
        this.sqlSegmentsMetadata.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
        Assert.assertEquals((long)0L, (long)this.sqlSegmentsMetadata.markAsUsedNonOvershadowedSegments("wikipedia2", (Set)segmentIds));
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsInInterval() throws IOException {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SQLMetadataSegmentManagerTest.createSegment("wikipedia2", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 1);
        DataSegment newSegment3 = SQLMetadataSegmentManagerTest.createSegment("wikipedia2", "2017-10-19T00:00:00.000/2017-10-20T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        DataSegment newSegment4 = SQLMetadataSegmentManagerTest.createNewSegment2("wikipedia2");
        this.publish(newSegment1, false);
        this.publish(newSegment2, false);
        this.publish(newSegment3, false);
        this.publish(newSegment4, false);
        Interval theInterval = Intervals.of((String)"2017-10-15T00:00:00.000/2017-10-18T00:00:00.000");
        this.sqlSegmentsMetadata.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
        Assert.assertEquals((long)2L, (long)this.sqlSegmentsMetadata.markAsUsedNonOvershadowedSegmentsInInterval("wikipedia2", theInterval));
        this.sqlSegmentsMetadata.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment1, (Object)newSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMarkAsUsedNonOvershadowedSegmentsInIntervalWithInvalidInterval() throws IOException {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SQLMetadataSegmentManagerTest.createNewSegment2("wikipedia2");
        this.publish(newSegment1, false);
        this.publish(newSegment2, false);
        Interval theInterval = Intervals.of((String)"2017-10-22T00:00:00.000/2017-10-02T00:00:00.000");
        this.sqlSegmentsMetadata.markAsUsedNonOvershadowedSegmentsInInterval("wikipedia2", theInterval);
    }

    @Test
    public void testMarkAsUsedNonOvershadowedSegmentsInIntervalWithOverlappingInterval() throws IOException {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SQLMetadataSegmentManagerTest.createSegment("wikipedia2", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        DataSegment newSegment2 = SQLMetadataSegmentManagerTest.createSegment("wikipedia2", "2017-10-17T00:00:00.000/2017-10-18T00:00:00.000", "2017-10-16T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 1);
        DataSegment newSegment3 = SQLMetadataSegmentManagerTest.createSegment("wikipedia2", "2017-10-19T00:00:00.000/2017-10-22T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        DataSegment newSegment4 = SQLMetadataSegmentManagerTest.createNewSegment2("wikipedia2");
        this.publish(newSegment1, false);
        this.publish(newSegment2, false);
        this.publish(newSegment3, false);
        this.publish(newSegment4, false);
        Interval theInterval = Intervals.of((String)"2017-10-16T00:00:00.000/2017-10-20T00:00:00.000");
        this.sqlSegmentsMetadata.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
        Assert.assertEquals((long)1L, (long)this.sqlSegmentsMetadata.markAsUsedNonOvershadowedSegmentsInInterval("wikipedia2", theInterval));
        this.sqlSegmentsMetadata.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkSegmentsAsUnused() throws IOException {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        this.publisher.publishSegment(newSegment1);
        this.publisher.publishSegment(newSegment2);
        ImmutableSet segmentIds = ImmutableSet.of((Object)newSegment1.getId().toString(), (Object)newSegment1.getId().toString());
        Assert.assertEquals((long)segmentIds.size(), (long)this.sqlSegmentsMetadata.markSegmentsAsUnused("wikipedia2", (Set)segmentIds));
        this.sqlSegmentsMetadata.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkSegmentsAsUnusedInvalidDataSource() throws IOException {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        this.publisher.publishSegment(newSegment1);
        this.publisher.publishSegment(newSegment2);
        ImmutableSet segmentIds = ImmutableSet.of((Object)newSegment1.getId().toString(), (Object)newSegment2.getId().toString());
        Assert.assertEquals((long)0L, (long)this.sqlSegmentsMetadata.markSegmentsAsUnused("wrongDataSource", (Set)segmentIds));
        this.sqlSegmentsMetadata.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment1, (Object)newSegment2), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
    }

    @Test
    public void testMarkAsUnusedSegmentsInInterval() throws IOException {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SQLMetadataSegmentManagerTest.createNewSegment2("wikipedia2");
        DataSegment newSegment3 = SQLMetadataSegmentManagerTest.createSegment("wikipedia2", "2017-10-19T00:00:00.000/2017-10-20T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        this.publisher.publishSegment(newSegment1);
        this.publisher.publishSegment(newSegment2);
        this.publisher.publishSegment(newSegment3);
        Interval theInterval = Intervals.of((String)"2017-10-15T00:00:00.000/2017-10-18T00:00:00.000");
        Assert.assertEquals((long)2L, (long)this.sqlSegmentsMetadata.markAsUnusedSegmentsInInterval("wikipedia2", theInterval));
        this.sqlSegmentsMetadata.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment3), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMarkAsUnusedSegmentsInIntervalWithInvalidInterval() throws IOException {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SQLMetadataSegmentManagerTest.createNewSegment1("wikipedia2");
        DataSegment newSegment2 = SQLMetadataSegmentManagerTest.createNewSegment2("wikipedia2");
        this.publisher.publishSegment(newSegment1);
        this.publisher.publishSegment(newSegment2);
        Interval theInterval = Intervals.of((String)"2017-10-22T00:00:00.000/2017-10-02T00:00:00.000");
        this.sqlSegmentsMetadata.markAsUnusedSegmentsInInterval("wikipedia2", theInterval);
    }

    @Test
    public void testMarkAsUnusedSegmentsInIntervalWithOverlappingInterval() throws IOException {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        String newDataSource = "wikipedia2";
        DataSegment newSegment1 = SQLMetadataSegmentManagerTest.createSegment("wikipedia2", "2017-10-15T00:00:00.000/2017-10-17T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        DataSegment newSegment2 = SQLMetadataSegmentManagerTest.createNewSegment2("wikipedia2");
        DataSegment newSegment3 = SQLMetadataSegmentManagerTest.createSegment("wikipedia2", "2017-10-19T00:00:00.000/2017-10-22T00:00:00.000", "2017-10-15T20:19:12.565Z", "index/y=2017/m=10/d=15/2017-10-16T20:19:12.565Z/0/index.zip", 0);
        this.publisher.publishSegment(newSegment1);
        this.publisher.publishSegment(newSegment2);
        this.publisher.publishSegment(newSegment3);
        Interval theInterval = Intervals.of((String)"2017-10-16T00:00:00.000/2017-10-20T00:00:00.000");
        Assert.assertEquals((long)1L, (long)this.sqlSegmentsMetadata.markAsUnusedSegmentsInInterval("wikipedia2", theInterval));
        this.sqlSegmentsMetadata.poll();
        Assert.assertEquals((Object)ImmutableSet.of((Object)this.segment1, (Object)this.segment2, (Object)newSegment1, (Object)newSegment3), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
    }

    @Test
    public void testStopAndStart() {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.stopPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.stopPollingDatabasePeriodically();
    }
}

