/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.metadata;

import java.util.stream.Collectors;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.client.ImmutableDruidDataSource;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataSegmentManagerConfig;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataSegmentManager;
import org.apache.hive.druid.org.apache.druid.metadata.TestDerbyConnector;
import org.apache.hive.druid.org.apache.druid.segment.TestHelper;
import org.joda.time.Period;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class SQLMetadataSegmentManagerEmptyTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private SQLMetadataSegmentManager sqlSegmentsMetadata;
    private final ObjectMapper jsonMapper = TestHelper.makeJsonMapper();

    @Before
    public void setUp() throws Exception {
        TestDerbyConnector connector = this.derbyConnectorRule.getConnector();
        MetadataSegmentManagerConfig config = new MetadataSegmentManagerConfig();
        config.setPollDuration(Period.seconds((int)1));
        this.sqlSegmentsMetadata = new SQLMetadataSegmentManager(this.jsonMapper, Suppliers.ofInstance((Object)config), this.derbyConnectorRule.metadataTablesConfigSupplier(), (SQLMetadataConnector)connector);
        this.sqlSegmentsMetadata.start();
        connector.createSegmentTable();
    }

    @After
    public void teardown() {
        if (this.sqlSegmentsMetadata.isPollingDatabasePeriodically()) {
            this.sqlSegmentsMetadata.stopPollingDatabasePeriodically();
        }
        this.sqlSegmentsMetadata.stop();
    }

    @Test
    public void testPollEmpty() {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.poll();
        Assert.assertTrue((boolean)this.sqlSegmentsMetadata.isPollingDatabasePeriodically());
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)this.sqlSegmentsMetadata.retrieveAllDataSourceNames());
        Assert.assertEquals((Object)ImmutableList.of(), this.sqlSegmentsMetadata.getImmutableDataSourcesWithAllUsedSegments().stream().map(ImmutableDruidDataSource::getName).collect(Collectors.toList()));
        Assert.assertEquals(null, (Object)this.sqlSegmentsMetadata.getImmutableDataSourceWithUsedSegments("wikipedia"));
        Assert.assertEquals((Object)ImmutableSet.of(), (Object)ImmutableSet.copyOf((Iterable)this.sqlSegmentsMetadata.iterateAllUsedSegments()));
    }

    @Test
    public void testStopAndStart() {
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.stopPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.startPollingDatabasePeriodically();
        this.sqlSegmentsMetadata.stopPollingDatabasePeriodically();
    }
}

