/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Suppliers;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.audit.AuditEntry;
import org.apache.hive.druid.org.apache.druid.audit.AuditInfo;
import org.apache.hive.druid.org.apache.druid.audit.AuditManager;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataRuleManagerConfig;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.hive.druid.org.apache.druid.metadata.SQLMetadataRuleManager;
import org.apache.hive.druid.org.apache.druid.metadata.TestDerbyConnector;
import org.apache.hive.druid.org.apache.druid.server.audit.SQLAuditManager;
import org.apache.hive.druid.org.apache.druid.server.audit.SQLAuditManagerConfig;
import org.apache.hive.druid.org.apache.druid.server.coordinator.rules.IntervalLoadRule;
import org.apache.hive.druid.org.apache.druid.server.metrics.NoopServiceEmitter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class SQLMetadataRuleManagerTest {
    @Rule
    public final TestDerbyConnector.DerbyConnectorRule derbyConnectorRule = new TestDerbyConnector.DerbyConnectorRule();
    private TestDerbyConnector connector;
    private MetadataStorageTablesConfig tablesConfig;
    private SQLMetadataRuleManager ruleManager;
    private AuditManager auditManager;
    private final ObjectMapper mapper = new DefaultObjectMapper();

    @Before
    public void setUp() {
        this.connector = this.derbyConnectorRule.getConnector();
        this.tablesConfig = (MetadataStorageTablesConfig)this.derbyConnectorRule.metadataTablesConfigSupplier().get();
        this.connector.createAuditTable();
        this.auditManager = new SQLAuditManager((SQLMetadataConnector)this.connector, Suppliers.ofInstance((Object)this.tablesConfig), (ServiceEmitter)new NoopServiceEmitter(), this.mapper, new SQLAuditManagerConfig());
        this.connector.createRulesTable();
        this.ruleManager = new SQLMetadataRuleManager(this.mapper, new MetadataRuleManagerConfig(), this.tablesConfig, (SQLMetadataConnector)this.connector, this.auditManager);
    }

    @Test
    public void testMultipleStopAndStart() {
        this.ruleManager.start();
        this.ruleManager.stop();
        this.ruleManager.start();
        this.ruleManager.stop();
    }

    @Test
    public void testRuleInsert() {
        List<IntervalLoadRule> rules = Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2)));
        AuditInfo auditInfo = new AuditInfo("test_author", "test_comment", "127.0.0.1");
        this.ruleManager.overrideRule("test_dataSource", rules, auditInfo);
        Map allRules = this.ruleManager.getAllRules();
        Assert.assertEquals((long)1L, (long)allRules.size());
        Assert.assertEquals((long)1L, (long)((List)allRules.get("test_dataSource")).size());
        Assert.assertEquals((Object)rules.get(0), ((List)allRules.get("test_dataSource")).get(0));
    }

    @Test
    public void testAuditEntryCreated() throws Exception {
        List<IntervalLoadRule> rules = Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2)));
        AuditInfo auditInfo = new AuditInfo("test_author", "test_comment", "127.0.0.1");
        this.ruleManager.overrideRule("test_dataSource", rules, auditInfo);
        this.ruleManager.poll();
        Assert.assertEquals(rules, (Object)this.ruleManager.getRules("test_dataSource"));
        List auditEntries = this.auditManager.fetchAuditHistory("test_dataSource", "rules", null);
        Assert.assertEquals((long)1L, (long)auditEntries.size());
        AuditEntry entry = (AuditEntry)auditEntries.get(0);
        Assert.assertEquals(rules, (Object)this.mapper.readValue(entry.getPayload(), (TypeReference)new TypeReference<List<org.apache.hive.druid.org.apache.druid.server.coordinator.rules.Rule>>(){}));
        Assert.assertEquals((Object)auditInfo, (Object)entry.getAuditInfo());
        Assert.assertEquals((Object)"test_dataSource", (Object)entry.getKey());
    }

    @Test
    public void testFetchAuditEntriesForAllDataSources() throws Exception {
        List<IntervalLoadRule> rules = Collections.singletonList(new IntervalLoadRule(Intervals.of((String)"2015-01-01/2015-02-01"), (Map)ImmutableMap.of((Object)"_default_tier", (Object)2)));
        AuditInfo auditInfo = new AuditInfo("test_author", "test_comment", "127.0.0.1");
        this.ruleManager.overrideRule("test_dataSource", rules, auditInfo);
        this.ruleManager.overrideRule("test_dataSource2", rules, auditInfo);
        this.ruleManager.poll();
        Assert.assertEquals(rules, (Object)this.ruleManager.getRules("test_dataSource"));
        Assert.assertEquals(rules, (Object)this.ruleManager.getRules("test_dataSource2"));
        List auditEntries = this.auditManager.fetchAuditHistory("rules", null);
        Assert.assertEquals((long)2L, (long)auditEntries.size());
        for (AuditEntry entry : auditEntries) {
            Assert.assertEquals(rules, (Object)this.mapper.readValue(entry.getPayload(), (TypeReference)new TypeReference<List<org.apache.hive.druid.org.apache.druid.server.coordinator.rules.Rule>>(){}));
            Assert.assertEquals((Object)auditInfo, (Object)entry.getAuditInfo());
        }
    }

    @After
    public void cleanup() {
        this.dropTable(this.tablesConfig.getAuditTable());
        this.dropTable(this.tablesConfig.getRulesTable());
    }

    private void dropTable(final String tableName) {
        this.connector.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) {
                handle.createStatement(StringUtils.format((String)"DROP TABLE %s", (Object[])new Object[]{tableName})).execute();
                return null;
            }
        });
    }
}

