/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.metadata;

import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.metadata.DefaultPasswordProvider;
import org.apache.hive.druid.org.apache.druid.metadata.PasswordProvider;
import org.apache.hive.druid.org.apache.druid.metadata.PasswordProviderRedactionMixIn;
import org.junit.Assert;
import org.junit.Test;

public class DefaultPasswordProviderTest {
    private static final String PWD = "nothing";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();

    @Test
    public void testExplicitConstruction() {
        DefaultPasswordProvider pp = new DefaultPasswordProvider(PWD);
        Assert.assertEquals((Object)PWD, (Object)pp.getPassword());
    }

    @Test
    public void testFromStringConstruction() {
        DefaultPasswordProvider pp = DefaultPasswordProvider.fromString((String)PWD);
        Assert.assertEquals((Object)PWD, (Object)pp.getPassword());
    }

    @Test
    public void testDeserializationFromJsonString() throws Exception {
        PasswordProvider pp = (PasswordProvider)JSON_MAPPER.readValue("\"nothing\"", PasswordProvider.class);
        Assert.assertEquals((Object)PWD, (Object)pp.getPassword());
    }

    @Test
    public void testDeserializationFromJson() throws Exception {
        PasswordProvider pp = (PasswordProvider)JSON_MAPPER.readValue("{\"type\": \"default\", \"password\": \"nothing\"}", PasswordProvider.class);
        Assert.assertEquals((Object)PWD, (Object)pp.getPassword());
    }

    @Test
    public void testSerializationWithMixIn() throws Exception {
        DefaultPasswordProvider pp = new DefaultPasswordProvider(PWD);
        JSON_MAPPER.addMixIn(PasswordProvider.class, PasswordProviderRedactionMixIn.class);
        String valueAsString = JSON_MAPPER.writeValueAsString((Object)pp);
        Assert.assertEquals((Object)"{\"type\":\"default\"}", (Object)valueAsString);
    }
}

