/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.math.expr;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.math.expr.Parser;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Test;

public class ParserTest
extends InitializedNullHandlingTest {
    @Test
    public void testSimple() {
        String actual = Parser.parse((String)"1", (ExprMacroTable)ExprMacroTable.nil()).toString();
        String expected = "1";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleUnaryOps1() {
        String actual = Parser.parse((String)"-x", (ExprMacroTable)ExprMacroTable.nil()).toString();
        String expected = "-x";
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = Parser.parse((String)"!x", (ExprMacroTable)ExprMacroTable.nil()).toString();
        expected = "!x";
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSimpleUnaryOps2() {
        this.validateFlatten("-1", "-1", "-1");
        this.validateFlatten("--1", "--1", "1");
        this.validateFlatten("-1+2", "(+ -1 2)", "1");
        this.validateFlatten("-1*2", "(* -1 2)", "-2");
        this.validateFlatten("-1^2", "(^ -1 2)", "1");
    }

    @Test
    public void testSimpleLogicalOps1() {
        this.validateParser("x>y", "(> x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x<y", "(< x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x<=y", "(<= x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x>=y", "(>= x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x==y", "(== x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x!=y", "(!= x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x && y", "(&& x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x || y", "(|| x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
    }

    @Test
    public void testSimpleAdditivityOp1() {
        this.validateParser("x+y", "(+ x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x-y", "(- x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
    }

    @Test
    public void testSimpleAdditivityOp2() {
        this.validateParser("x+y+z", "(+ (+ x y) z)", (List<String>)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"));
        this.validateParser("x+y-z", "(- (+ x y) z)", (List<String>)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"));
        this.validateParser("x-y+z", "(+ (- x y) z)", (List<String>)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"));
        this.validateParser("x-y-z", "(- (- x y) z)", (List<String>)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"));
        this.validateParser("x-y-x", "(- (- x y) x)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"), (Set<String>)ImmutableSet.of((Object)"x", (Object)"x_0", (Object)"y"));
    }

    @Test
    public void testSimpleMultiplicativeOp1() {
        this.validateParser("x*y", "(* x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x/y", "(/ x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateParser("x%y", "(% x y)", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
    }

    @Test
    public void testSimpleMultiplicativeOp2() {
        this.validateFlatten("1*2*3", "(* (* 1 2) 3)", "6");
        this.validateFlatten("1*2/3", "(/ (* 1 2) 3)", "0");
        this.validateFlatten("1/2*3", "(* (/ 1 2) 3)", "0");
        this.validateFlatten("1/2/3", "(/ (/ 1 2) 3)", "0");
        this.validateFlatten("1.0*2*3", "(* (* 1.0 2) 3)", "6.0");
        this.validateFlatten("1.0*2/3", "(/ (* 1.0 2) 3)", "0.6666666666666666");
        this.validateFlatten("1.0/2*3", "(* (/ 1.0 2) 3)", "1.5");
        this.validateFlatten("1.0/2/3", "(/ (/ 1.0 2) 3)", "0.16666666666666666");
        this.validateFlatten("1.0*2*x", "(* (* 1.0 2) x)", "(* 2.0 x)");
        this.validateFlatten("1.0*2/x", "(/ (* 1.0 2) x)", "(/ 2.0 x)");
        this.validateFlatten("1.0/2*x", "(* (/ 1.0 2) x)", "(* 0.5 x)");
        this.validateFlatten("1.0/2/x", "(/ (/ 1.0 2) x)", "(/ 0.5 x)");
        this.validateFlatten("1.0*x*3", "(* (* 1.0 x) 3)", "(* (* 1.0 x) 3)");
    }

    @Test
    public void testSimpleCarrot1() {
        this.validateFlatten("1^2", "(^ 1 2)", "1");
    }

    @Test
    public void testSimpleCarrot2() {
        this.validateFlatten("1^2^3", "(^ 1 (^ 2 3))", "1");
    }

    @Test
    public void testMixed() {
        this.validateFlatten("1+2*3", "(+ 1 (* 2 3))", "7");
        this.validateFlatten("1+(2*3)", "(+ 1 (* 2 3))", "7");
        this.validateFlatten("(1+2)*3", "(* (+ 1 2) 3)", "9");
        this.validateFlatten("1*2+3", "(+ (* 1 2) 3)", "5");
        this.validateFlatten("(1*2)+3", "(+ (* 1 2) 3)", "5");
        this.validateFlatten("1*(2+3)", "(* 1 (+ 2 3))", "5");
        this.validateFlatten("1+2^3", "(+ 1 (^ 2 3))", "9");
        this.validateFlatten("1+(2^3)", "(+ 1 (^ 2 3))", "9");
        this.validateFlatten("(1+2)^3", "(^ (+ 1 2) 3)", "27");
        this.validateFlatten("1^2+3", "(+ (^ 1 2) 3)", "4");
        this.validateFlatten("(1^2)+3", "(+ (^ 1 2) 3)", "4");
        this.validateFlatten("1^(2+3)", "(^ 1 (+ 2 3))", "1");
        this.validateFlatten("1^2*3+4", "(+ (* (^ 1 2) 3) 4)", "7");
        this.validateFlatten("-1^2*-3+-4", "(+ (* (^ -1 2) -3) -4)", "-7");
        this.validateFlatten("max(3, 4)", "(max [3, 4])", "4");
        this.validateFlatten("min(1, max(3, 4))", "(min [1, (max [3, 4])])", "1");
    }

    @Test
    public void testIdentifiers() {
        this.validateParser("foo", "foo", (List<String>)ImmutableList.of((Object)"foo"), (Set<String>)ImmutableSet.of());
        this.validateParser("\"foo\"", "foo", (List<String>)ImmutableList.of((Object)"foo"), (Set<String>)ImmutableSet.of());
        this.validateParser("\"foo bar\"", "foo bar", (List<String>)ImmutableList.of((Object)"foo bar"), (Set<String>)ImmutableSet.of());
        this.validateParser("\"foo\\\"bar\"", "foo\"bar", (List<String>)ImmutableList.of((Object)"foo\"bar"), (Set<String>)ImmutableSet.of());
    }

    @Test
    public void testLiterals() {
        this.validateConstantExpression("'foo'", "foo");
        this.validateConstantExpression("'foo bar'", "foo bar");
        this.validateConstantExpression("'f\u00f6o bar'", "f\u00f6o bar");
        this.validateConstantExpression("'f\\u0040o bar'", "f@o bar");
        this.validateConstantExpression("'f\\u000Ao \\'b\\\\\\\"ar'", "f\no 'b\\\"ar");
    }

    @Test
    public void testLiteralArrays() {
        this.validateConstantExpression("[1.0, 2.345]", new Double[]{1.0, 2.345});
        this.validateConstantExpression("[1, 3]", new Long[]{1L, 3L});
        this.validateConstantExpression("['hello', 'world']", new String[]{"hello", "world"});
    }

    @Test
    public void testFunctions() {
        this.validateParser("sqrt(x)", "(sqrt [x])", (List<String>)ImmutableList.of((Object)"x"));
        this.validateParser("if(cond,then,else)", "(if [cond, then, else])", (List<String>)ImmutableList.of((Object)"cond", (Object)"else", (Object)"then"));
        this.validateParser("cast(x, 'STRING')", "(cast [x, STRING])", (List<String>)ImmutableList.of((Object)"x"));
        this.validateParser("cast(x, 'LONG')", "(cast [x, LONG])", (List<String>)ImmutableList.of((Object)"x"));
        this.validateParser("cast(x, 'DOUBLE')", "(cast [x, DOUBLE])", (List<String>)ImmutableList.of((Object)"x"));
        this.validateParser("cast(x, 'STRING_ARRAY')", "(cast [x, STRING_ARRAY])", (List<String>)ImmutableList.of((Object)"x"), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of((Object)"x"));
        this.validateParser("cast(x, 'LONG_ARRAY')", "(cast [x, LONG_ARRAY])", (List<String>)ImmutableList.of((Object)"x"), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of((Object)"x"));
        this.validateParser("cast(x, 'DOUBLE_ARRAY')", "(cast [x, DOUBLE_ARRAY])", (List<String>)ImmutableList.of((Object)"x"), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of((Object)"x"));
        this.validateParser("array_length(x)", "(array_length [x])", (List<String>)ImmutableList.of((Object)"x"), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of((Object)"x"));
        this.validateParser("array_concat(x, y)", "(array_concat [x, y])", (List<String>)ImmutableList.of((Object)"x", (Object)"y"), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of((Object)"x", (Object)"y"));
        this.validateParser("array_append(x, y)", "(array_append [x, y])", (List<String>)ImmutableList.of((Object)"x", (Object)"y"), (Set<String>)ImmutableSet.of((Object)"y"), (Set<String>)ImmutableSet.of((Object)"x"));
        this.validateFlatten("sqrt(4)", "(sqrt [4])", "2.0");
        this.validateFlatten("array_concat([1, 2], [3, 4])", "(array_concat [[1, 2], [3, 4]])", "[1, 2, 3, 4]");
    }

    @Test
    public void testApplyFunctions() {
        this.validateParser("map(() -> 1, x)", "(map ([] -> 1), [x])", (List<String>)ImmutableList.of((Object)"x"), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of((Object)"x"));
        this.validateParser("map((x) -> x + 1, x)", "(map ([x] -> (+ x 1)), [x])", (List<String>)ImmutableList.of((Object)"x"), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of((Object)"x"));
        this.validateParser("x + map((x) -> x + 1, y)", "(+ x (map ([x] -> (+ x 1)), [y]))", (List<String>)ImmutableList.of((Object)"x", (Object)"y"), (Set<String>)ImmutableSet.of((Object)"x"), (Set<String>)ImmutableSet.of((Object)"y"));
        this.validateParser("x + map((x) -> x + 1, x)", "(+ x (map ([x] -> (+ x 1)), [x]))", (List<String>)ImmutableList.of((Object)"x"), (Set<String>)ImmutableSet.of((Object)"x"), (Set<String>)ImmutableSet.of((Object)"x_0"));
        this.validateParser("map((x) -> concat(x, y), z)", "(map ([x] -> (concat [x, y])), [z])", (List<String>)ImmutableList.of((Object)"y", (Object)"z"), (Set<String>)ImmutableSet.of((Object)"y"), (Set<String>)ImmutableSet.of((Object)"z"));
        this.validateParser("fold((x, acc) -> acc + x, x, y)", "(fold ([x, acc] -> (+ acc x)), [x, y])", (List<String>)ImmutableList.of((Object)"x", (Object)"y"), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of((Object)"x"));
        this.validateParser("fold((x, acc) -> acc + x, map((x) -> x + 1, x), y)", "(fold ([x, acc] -> (+ acc x)), [(map ([x] -> (+ x 1)), [x]), y])", (List<String>)ImmutableList.of((Object)"x", (Object)"y"), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of((Object)"x"));
        this.validateParser("array_append(z, fold((x, acc) -> acc + x, map((x) -> x + 1, x), y))", "(array_append [z, (fold ([x, acc] -> (+ acc x)), [(map ([x] -> (+ x 1)), [x]), y])])", (List<String>)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of((Object)"x", (Object)"z"));
        this.validateParser("map(z -> z + 1, array_append(z, fold((x, acc) -> acc + x, map((x) -> x + 1, x), y)))", "(map ([z] -> (+ z 1)), [(array_append [z, (fold ([x, acc] -> (+ acc x)), [(map ([x] -> (+ x 1)), [x]), y])])])", (List<String>)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of((Object)"x", (Object)"z"));
        this.validateParser("array_append(map(z -> z + 1, array_append(z, fold((x, acc) -> acc + x, map((x) -> x + 1, x), y))), a)", "(array_append [(map ([z] -> (+ z 1)), [(array_append [z, (fold ([x, acc] -> (+ acc x)), [(map ([x] -> (+ x 1)), [x]), y])])]), a])", (List<String>)ImmutableList.of((Object)"x", (Object)"y", (Object)"a", (Object)"z"), (Set<String>)ImmutableSet.of((Object)"a"), (Set<String>)ImmutableSet.of((Object)"x", (Object)"z"));
        this.validateFlatten("map((x) -> x + 1, [1, 2, 3, 4])", "(map ([x] -> (+ x 1)), [[1, 2, 3, 4]])", "[2, 3, 4, 5]");
        this.validateFlatten("map((x) -> x + z, [1, 2, 3, 4])", "(map ([x] -> (+ x z)), [[1, 2, 3, 4]])", "(map ([x] -> (+ x z)), [[1, 2, 3, 4]])");
    }

    @Test
    public void testApplyUnapplied() {
        this.validateApplyUnapplied("x + 1", "(+ x 1)", "(+ x 1)", (List<String>)ImmutableList.of());
        this.validateApplyUnapplied("x + 1", "(+ x 1)", "(+ x 1)", (List<String>)ImmutableList.of((Object)"z"));
        this.validateApplyUnapplied("x + y", "(+ x y)", "(map ([x] -> (+ x y)), [x])", (List<String>)ImmutableList.of((Object)"x"));
        this.validateApplyUnapplied("x + y", "(+ x y)", "(cartesian_map ([x, y] -> (+ x y)), [x, y])", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateApplyUnapplied("map(x -> x + y, x)", "(map ([x] -> (+ x y)), [x])", "(cartesian_map ([x, y] -> (+ x y)), [x, y])", (List<String>)ImmutableList.of((Object)"y"));
        this.validateApplyUnapplied("map(x -> x + 1, x + 1)", "(map ([x] -> (+ x 1)), [(+ x 1)])", "(map ([x] -> (+ x 1)), [(map ([x] -> (+ x 1)), [x])])", (List<String>)ImmutableList.of((Object)"x"));
        this.validateApplyUnapplied("fold((x, acc) -> acc + x + y, x, 0)", "(fold ([x, acc] -> (+ (+ acc x) y)), [x, 0])", "(cartesian_fold ([x, y, acc] -> (+ (+ acc x) y)), [x, y, 0])", (List<String>)ImmutableList.of((Object)"y"));
        this.validateApplyUnapplied("z + fold((x, acc) -> acc + x + y, x, 0)", "(+ z (fold ([x, acc] -> (+ (+ acc x) y)), [x, 0]))", "(+ z (cartesian_fold ([x, y, acc] -> (+ (+ acc x) y)), [x, y, 0]))", (List<String>)ImmutableList.of((Object)"y"));
        this.validateApplyUnapplied("z + fold((x, acc) -> acc + x + y, x, 0)", "(+ z (fold ([x, acc] -> (+ (+ acc x) y)), [x, 0]))", "(map ([z] -> (+ z (cartesian_fold ([x, y, acc] -> (+ (+ acc x) y)), [x, y, 0]))), [z])", (List<String>)ImmutableList.of((Object)"y", (Object)"z"));
        this.validateApplyUnapplied("array_to_string(concat(x, 'hello'), ',')", "(array_to_string [(concat [x, hello]), ,])", "(array_to_string [(map ([x] -> (concat [x, hello])), [x]), ,])", (List<String>)ImmutableList.of((Object)"x", (Object)"y"));
        this.validateApplyUnapplied("cast(x, 'LONG')", "(cast [x, LONG])", "(map ([x] -> (cast [x, LONG])), [x])", (List<String>)ImmutableList.of((Object)"x"));
        this.validateApplyUnapplied("cartesian_map((x,y) -> x + y, x, y)", "(cartesian_map ([x, y] -> (+ x y)), [x, y])", "(cartesian_map ([x, y] -> (+ x y)), [x, y])", (List<String>)ImmutableList.of((Object)"y"));
        this.validateApplyUnapplied("cast(x, 'LONG_ARRAY')", "(cast [x, LONG_ARRAY])", "(cast [x, LONG_ARRAY])", (List<String>)ImmutableList.of((Object)"x"));
        this.validateApplyUnapplied("case_searched((x == 'b'),'b',(x == 'g'),'g','Other')", "(case_searched [(== x b), b, (== x g), g, Other])", "(map ([x] -> (case_searched [(== x b), b, (== x g), g, Other])), [x])", (List<String>)ImmutableList.of((Object)"x"));
    }

    @Test
    public void testUniquify() {
        this.validateParser("x-x", "(- x x)", (List<String>)ImmutableList.of((Object)"x"), (Set<String>)ImmutableSet.of((Object)"x", (Object)"x_0"));
        this.validateParser("x - x + x", "(+ (- x x) x)", (List<String>)ImmutableList.of((Object)"x"), (Set<String>)ImmutableSet.of((Object)"x", (Object)"x_0", (Object)"x_1"));
        this.validateParser("map((x) -> x + x, x)", "(map ([x] -> (+ x x)), [x])", (List<String>)ImmutableList.of((Object)"x"), (Set<String>)ImmutableSet.of(), (Set<String>)ImmutableSet.of((Object)"x"));
        this.validateApplyUnapplied("x + x", "(+ x x)", "(map ([x] -> (+ x x)), [x])", (List<String>)ImmutableList.of((Object)"x"));
        this.validateApplyUnapplied("x + x + x", "(+ (+ x x) x)", "(map ([x] -> (+ (+ x x) x)), [x])", (List<String>)ImmutableList.of((Object)"x"));
        this.validateApplyUnapplied("x + x + x + y + y + y + y + z + z + z", "(+ (+ (+ (+ (+ (+ (+ (+ (+ x x) x) y) y) y) y) z) z) z)", "(cartesian_map ([x, y, z] -> (+ (+ (+ (+ (+ (+ (+ (+ (+ x x) x) y) y) y) y) z) z) z)), [x, y, z])", (List<String>)ImmutableList.of((Object)"x", (Object)"y", (Object)"z"));
    }

    private void validateFlatten(String expression, String withoutFlatten, String withFlatten) {
        Assert.assertEquals((String)expression, (Object)withoutFlatten, (Object)Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil(), (boolean)false).toString());
        Assert.assertEquals((String)expression, (Object)withFlatten, (Object)Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil(), (boolean)true).toString());
    }

    private void validateParser(String expression, String expected, List<String> identifiers) {
        this.validateParser(expression, expected, identifiers, (Set<String>)ImmutableSet.copyOf(identifiers), Collections.emptySet());
    }

    private void validateParser(String expression, String expected, List<String> identifiers, Set<String> scalars) {
        this.validateParser(expression, expected, identifiers, scalars, Collections.emptySet());
    }

    private void validateParser(String expression, String expected, List<String> identifiers, Set<String> scalars, Set<String> arrays) {
        Expr parsed = Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil());
        Expr.BindingDetails deets = parsed.analyzeInputs();
        Assert.assertEquals((String)expression, (Object)expected, (Object)parsed.toString());
        Assert.assertEquals((String)expression, identifiers, (Object)deets.getRequiredBindingsList());
        Assert.assertEquals((String)expression, scalars, (Object)deets.getScalarVariables());
        Assert.assertEquals((String)expression, arrays, (Object)deets.getArrayVariables());
    }

    private void validateApplyUnapplied(String expression, String unapplied, String applied, List<String> identifiers) {
        Expr parsed = Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil());
        Expr.BindingDetails deets = parsed.analyzeInputs();
        Parser.validateExpr((Expr)parsed, (Expr.BindingDetails)deets);
        Expr transformed = Parser.applyUnappliedBindings((Expr)parsed, (Expr.BindingDetails)deets, identifiers);
        Assert.assertEquals((String)expression, (Object)unapplied, (Object)parsed.toString());
        Assert.assertEquals((String)applied, (Object)applied, (Object)transformed.toString());
    }

    private void validateConstantExpression(String expression, Object expected) {
        Assert.assertEquals((String)expression, (Object)expected, (Object)Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil()).eval(Parser.withMap((Map)ImmutableMap.of())).value());
    }

    private void validateConstantExpression(String expression, Object[] expected) {
        Assert.assertArrayEquals((String)expression, (Object[])expected, (Object[])((Object[])Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil()).eval(Parser.withMap((Map)ImmutableMap.of())).value()));
    }
}

