/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.math.expr;

import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.common.config.NullHandling;
import org.apache.hive.druid.org.apache.druid.math.expr.Expr;
import org.apache.hive.druid.org.apache.druid.math.expr.ExprMacroTable;
import org.apache.hive.druid.org.apache.druid.math.expr.Parser;
import org.apache.hive.druid.org.apache.druid.testing.InitializedNullHandlingTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FunctionTest
extends InitializedNullHandlingTest {
    private Expr.ObjectBinding bindings;

    @Before
    public void setup() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"x", (Object)"foo");
        builder.put((Object)"y", (Object)2);
        builder.put((Object)"z", (Object)3.1);
        builder.put((Object)"a", (Object)new String[]{"foo", "bar", "baz", "foobar"});
        builder.put((Object)"b", (Object)new Long[]{1L, 2L, 3L, 4L, 5L});
        builder.put((Object)"c", (Object)new Double[]{3.1, 4.2, 5.3});
        this.bindings = Parser.withMap((Map)builder.build());
    }

    @Test
    public void testCaseSimple() {
        this.assertExpr("case_simple(x,'baz','is baz','foo','is foo','is other')", "is foo");
        this.assertExpr("case_simple(x,'baz','is baz','bar','is bar','is other')", "is other");
        this.assertExpr("case_simple(y,2,'is 2',3,'is 3','is other')", "is 2");
        this.assertExpr("case_simple(z,2,'is 2',3,'is 3','is other')", "is other");
    }

    @Test
    public void testCaseSearched() {
        this.assertExpr("case_searched(x=='baz','is baz',x=='foo','is foo','is other')", "is foo");
        this.assertExpr("case_searched(x=='baz','is baz',x=='bar','is bar','is other')", "is other");
        this.assertExpr("case_searched(y==2,'is 2',y==3,'is 3','is other')", "is 2");
        this.assertExpr("case_searched(z==2,'is 2',z==3,'is 3','is other')", "is other");
    }

    @Test
    public void testConcat() {
        this.assertExpr("concat(x,' ',y)", "foo 2");
        if (NullHandling.replaceWithDefault()) {
            this.assertExpr("concat(x,' ',nonexistent,' ',y)", "foo  2");
        } else {
            this.assertExpr("concat(x,' ',nonexistent,' ',y)", null);
        }
        this.assertExpr("concat(z)", "3.1");
        this.assertExpr("concat()", null);
    }

    @Test
    public void testReplace() {
        this.assertExpr("replace(x,'oo','ab')", "fab");
        this.assertExpr("replace(x,x,'ab')", "ab");
        this.assertExpr("replace(x,'oo',y)", "f2");
    }

    @Test
    public void testSubstring() {
        this.assertExpr("substring(x,0,2)", "fo");
        this.assertExpr("substring(x,1,2)", "oo");
        this.assertExpr("substring(x,y,1)", "o");
        this.assertExpr("substring(x,0,-1)", "foo");
        this.assertExpr("substring(x,0,100)", "foo");
    }

    @Test
    public void testStrlen() {
        this.assertExpr("strlen(x)", 3L);
        this.assertExpr("strlen(nonexistent)", NullHandling.defaultLongValue());
    }

    @Test
    public void testStrpos() {
        this.assertExpr("strpos(x, 'o')", 1L);
        this.assertExpr("strpos(x, 'o', 0)", 1L);
        this.assertExpr("strpos(x, 'o', 1)", 1L);
        this.assertExpr("strpos(x, 'o', 2)", 2L);
        this.assertExpr("strpos(x, 'o', 3)", -1L);
        this.assertExpr("strpos(x, '')", 0L);
        this.assertExpr("strpos(x, 'x')", -1L);
    }

    @Test
    public void testLower() {
        this.assertExpr("lower('FOO')", "foo");
    }

    @Test
    public void testUpper() {
        this.assertExpr("upper(x)", "FOO");
    }

    @Test
    public void testIsNull() {
        this.assertExpr("isnull(null)", 1L);
        this.assertExpr("isnull('abc')", 0L);
    }

    @Test
    public void testIsNotNull() {
        this.assertExpr("notnull(null)", 0L);
        this.assertExpr("notnull('abc')", 1L);
    }

    @Test
    public void testLpad() {
        this.assertExpr("lpad(x, 5, 'ab')", "abfoo");
        this.assertExpr("lpad(x, 4, 'ab')", "afoo");
        this.assertExpr("lpad(x, 2, 'ab')", "fo");
        this.assertExpr("lpad(x, 0, 'ab')", null);
        this.assertExpr("lpad(x, 5, null)", null);
        this.assertExpr("lpad(null, 5, x)", null);
    }

    @Test
    public void testRpad() {
        this.assertExpr("rpad(x, 5, 'ab')", "fooab");
        this.assertExpr("rpad(x, 4, 'ab')", "fooa");
        this.assertExpr("rpad(x, 2, 'ab')", "fo");
        this.assertExpr("rpad(x, 0, 'ab')", null);
        this.assertExpr("rpad(x, 5, null)", null);
        this.assertExpr("rpad(null, 5, x)", null);
    }

    @Test
    public void testArrayConstructor() {
        this.assertExpr("array(1, 2, 3, 4)", new Long[]{1L, 2L, 3L, 4L});
        this.assertExpr("array(1, 2, 3, 'bar')", new Long[]{1L, 2L, 3L, null});
        this.assertExpr("array(1.0)", new Double[]{1.0});
        this.assertExpr("array('foo', 'bar')", new String[]{"foo", "bar"});
    }

    @Test
    public void testArrayLength() {
        this.assertExpr("array_length([1,2,3])", 3L);
        this.assertExpr("array_length(a)", 4);
    }

    @Test
    public void testArrayOffset() {
        this.assertExpr("array_offset([1, 2, 3], 2)", 3L);
        this.assertExpr("array_offset([1, 2, 3], 3)", null);
        this.assertExpr("array_offset(a, 2)", "baz");
    }

    @Test
    public void testArrayOrdinal() {
        this.assertExpr("array_ordinal([1, 2, 3], 3)", 3L);
        this.assertExpr("array_ordinal([1, 2, 3], 4)", null);
        this.assertExpr("array_ordinal(a, 3)", "baz");
    }

    @Test
    public void testArrayOffsetOf() {
        this.assertExpr("array_offset_of([1, 2, 3], 3)", 2L);
        this.assertExpr("array_offset_of([1, 2, 3], 4)", NullHandling.replaceWithDefault() ? Long.valueOf(-1L) : null);
        this.assertExpr("array_offset_of(a, 'baz')", 2);
    }

    @Test
    public void testArrayOrdinalOf() {
        this.assertExpr("array_ordinal_of([1, 2, 3], 3)", 3L);
        this.assertExpr("array_ordinal_of([1, 2, 3], 4)", NullHandling.replaceWithDefault() ? Long.valueOf(-1L) : null);
        this.assertExpr("array_ordinal_of(a, 'baz')", 3);
    }

    @Test
    public void testArrayContains() {
        this.assertExpr("array_contains([1, 2, 3], 2)", 1L);
        this.assertExpr("array_contains([1, 2, 3], 4)", 0L);
        this.assertExpr("array_contains([1, 2, 3], [2, 3])", 1L);
        this.assertExpr("array_contains([1, 2, 3], [3, 4])", 0L);
        this.assertExpr("array_contains(b, [3, 4])", 1L);
    }

    @Test
    public void testArrayOverlap() {
        this.assertExpr("array_overlap([1, 2, 3], [2, 4, 6])", 1L);
        this.assertExpr("array_overlap([1, 2, 3], [4, 5, 6])", 0L);
    }

    @Test
    public void testArrayAppend() {
        this.assertExpr("array_append([1, 2, 3], 4)", new Long[]{1L, 2L, 3L, 4L});
        this.assertExpr("array_append([1, 2, 3], 'bar')", new Long[]{1L, 2L, 3L, null});
        this.assertExpr("array_append([], 1)", new String[]{"1"});
        this.assertExpr("array_append(cast([], 'LONG_ARRAY'), 1)", new Long[]{1L});
    }

    @Test
    public void testArrayConcat() {
        this.assertExpr("array_concat([1, 2, 3], [2, 4, 6])", new Long[]{1L, 2L, 3L, 2L, 4L, 6L});
        this.assertExpr("array_concat([1, 2, 3], 4)", new Long[]{1L, 2L, 3L, 4L});
        this.assertExpr("array_concat(0, [1, 2, 3])", new Long[]{0L, 1L, 2L, 3L});
        this.assertExpr("array_concat(map(y -> y * 3, b), [1, 2, 3])", new Long[]{3L, 6L, 9L, 12L, 15L, 1L, 2L, 3L});
        this.assertExpr("array_concat(0, 1)", new Long[]{0L, 1L});
    }

    @Test
    public void testArrayToString() {
        this.assertExpr("array_to_string([1, 2, 3], ',')", "1,2,3");
        this.assertExpr("array_to_string([1], '|')", "1");
        this.assertExpr("array_to_string(a, '|')", "foo|bar|baz|foobar");
    }

    @Test
    public void testStringToArray() {
        this.assertExpr("string_to_array('1,2,3', ',')", new String[]{"1", "2", "3"});
        this.assertExpr("string_to_array('1', ',')", new String[]{"1"});
        this.assertExpr("string_to_array(array_to_string(a, ','), ',')", new String[]{"foo", "bar", "baz", "foobar"});
    }

    @Test
    public void testArrayCast() {
        this.assertExpr("cast([1, 2, 3], 'STRING_ARRAY')", new String[]{"1", "2", "3"});
        this.assertExpr("cast([1, 2, 3], 'DOUBLE_ARRAY')", new Double[]{1.0, 2.0, 3.0});
        this.assertExpr("cast(c, 'LONG_ARRAY')", new Long[]{3L, 4L, 5L});
        this.assertExpr("cast(string_to_array(array_to_string(b, ','), ','), 'LONG_ARRAY')", new Long[]{1L, 2L, 3L, 4L, 5L});
        this.assertExpr("cast(['1.0', '2.0', '3.0'], 'LONG_ARRAY')", new Long[]{1L, 2L, 3L});
    }

    @Test
    public void testArraySlice() {
        this.assertExpr("array_slice([1, 2, 3, 4], 1, 3)", new Long[]{2L, 3L});
        this.assertExpr("array_slice([1.0, 2.1, 3.2, 4.3], 2)", new Double[]{3.2, 4.3});
        this.assertExpr("array_slice(['a', 'b', 'c', 'd'], 4, 6)", new String[]{null, null});
        this.assertExpr("array_slice([1, 2, 3, 4], 2, 2)", new Long[0]);
        this.assertExpr("array_slice([1, 2, 3, 4], 5, 7)", null);
        this.assertExpr("array_slice([1, 2, 3, 4], 2, 1)", null);
    }

    @Test
    public void testArrayPrepend() {
        this.assertExpr("array_prepend(4, [1, 2, 3])", new Long[]{4L, 1L, 2L, 3L});
        this.assertExpr("array_prepend('bar', [1, 2, 3])", new Long[]{null, 1L, 2L, 3L});
        this.assertExpr("array_prepend(1, [])", new String[]{"1"});
        this.assertExpr("array_prepend(1, cast([], 'LONG_ARRAY'))", new Long[]{1L});
    }

    private void assertExpr(String expression, Object expectedResult) {
        Expr expr = Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil());
        Assert.assertEquals((String)expression, (Object)expectedResult, (Object)expr.eval(this.bindings).value());
    }

    private void assertExpr(String expression, Object[] expectedResult) {
        Expr expr = Parser.parse((String)expression, (ExprMacroTable)ExprMacroTable.nil());
        Assert.assertArrayEquals((String)expression, (Object[])expectedResult, (Object[])expr.eval(this.bindings).asArray());
    }
}

