/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.metrics;

import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.Event;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.Monitor;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.Monitors;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.junit.Assert;
import org.junit.Test;

public class MonitorsTest {
    @Test
    public void testSetFeed() {
        String feed = "testFeed";
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        Monitor m = Monitors.createCompoundJvmMonitor((Map)ImmutableMap.of(), (String)feed);
        m.start();
        m.monitor((ServiceEmitter)emitter);
        m.stop();
        this.checkEvents(emitter.getEvents(), feed);
    }

    @Test
    public void testDefaultFeed() {
        StubServiceEmitter emitter = new StubServiceEmitter("dev/monitor-test", "localhost:0000");
        Monitor m = Monitors.createCompoundJvmMonitor((Map)ImmutableMap.of());
        m.start();
        m.monitor((ServiceEmitter)emitter);
        m.stop();
        this.checkEvents(emitter.getEvents(), "metrics");
    }

    private void checkEvents(List<Event> events, String expectedFeed) {
        Assert.assertFalse((String)"no events emitted", (boolean)events.isEmpty());
        for (Event e : events) {
            if (expectedFeed.equals(e.getFeed())) continue;
            String message = StringUtils.format((String)"\"feed\" in event: %s", (Object[])new Object[]{e.toMap().toString()});
            Assert.assertEquals((String)message, (Object)expectedFeed, (Object)e.getFeed());
        }
    }
}

