/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.metrics;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.Event;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.CgroupMemoryMonitor;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.StubServiceEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.cgroups.ProcCgroupDiscoverer;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.cgroups.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class CgroupMemoryMonitorTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File procDir;
    private File cgroupDir;
    private CgroupDiscoverer discoverer;

    @Before
    public void setUp() throws IOException {
        this.cgroupDir = this.temporaryFolder.newFolder();
        this.procDir = this.temporaryFolder.newFolder();
        this.discoverer = new ProcCgroupDiscoverer(this.procDir.toPath());
        TestUtils.setUpCgroups(this.procDir, this.cgroupDir);
        File memoryDir = new File(this.cgroupDir, "memory/system.slice/some.service");
        Assert.assertTrue((memoryDir.isDirectory() && memoryDir.exists() || memoryDir.mkdirs() ? 1 : 0) != 0);
        TestUtils.copyResource("/memory.stat", new File(memoryDir, "memory.stat"));
        TestUtils.copyResource("/memory.numa_stat", new File(memoryDir, "memory.numa_stat"));
    }

    @Test
    public void testMonitor() {
        CgroupMemoryMonitor monitor = new CgroupMemoryMonitor(this.discoverer, (Map)ImmutableMap.of(), "some_feed");
        StubServiceEmitter emitter = new StubServiceEmitter("service", "host");
        Assert.assertTrue((boolean)monitor.doMonitor((ServiceEmitter)emitter));
        List<Event> actualEvents = emitter.getEvents();
        Assert.assertEquals((long)44L, (long)actualEvents.size());
    }
}

