/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.metrics;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.hive.druid.org.apache.druid.java.util.common.logger.Logger;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.AllocationMetricCollector;
import org.apache.hive.druid.org.apache.druid.java.util.metrics.AllocationMetricCollectors;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AllocationMetricCollectorTest {
    private static final Logger log = new Logger(AllocationMetricCollectorTest.class);
    private final List<Thread> threads = new ArrayList<Thread>();
    private final int objectHeader64BitSize = 16;

    @Test
    public void testDelta() throws InterruptedException {
        AllocationMetricCollector collector = AllocationMetricCollectors.getAllocationMetricCollector();
        if (collector == null) {
            return;
        }
        long delta = collector.calculateDelta();
        Assert.assertNotNull((Object)delta);
        Assert.assertTrue((delta > 0L ? 1 : 0) != 0);
        log.info("First delta: %s", new Object[]{delta});
        int generatedSize2 = this.generateObjectsConcurrently(1000);
        long delta2 = collector.calculateDelta();
        Assert.assertTrue((delta2 > (long)generatedSize2 ? 1 : 0) != 0);
        log.info("Second delta: %s", new Object[]{delta2});
        int generatedSize3 = this.generateObjectsConcurrently(100000);
        long delta3 = collector.calculateDelta();
        Assert.assertTrue((delta3 > (long)generatedSize3 ? 1 : 0) != 0);
        log.info("Third delta: %s", new Object[]{delta3});
    }

    private int generateObjectsConcurrently(int countPerThread) throws InterruptedException {
        int threads = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        log.info("Threads: %s", new Object[]{threads});
        int objectsCount = countPerThread * threads;
        log.info("Total objects: %s", new Object[]{objectsCount});
        int totalSize = objectsCount * 16;
        log.info("Total size: %s", new Object[]{totalSize});
        CountDownLatch countDownLatch = new CountDownLatch(threads);
        for (int i = 0; i < threads; ++i) {
            Thread thread = new Thread(() -> {
                ArrayList<Object> list = new ArrayList<Object>(countPerThread);
                for (int j = 0; j < countPerThread; ++j) {
                    list.add(new Object());
                }
                countDownLatch.countDown();
                try {
                    Thread.sleep(Long.MAX_VALUE);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            thread.setDaemon(true);
            thread.start();
            this.threads.add(thread);
        }
        countDownLatch.await();
        return totalSize;
    }

    @After
    public void stopThreads() {
        for (Thread thread : this.threads) {
            thread.interrupt();
        }
    }
}

