/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.http.client.response;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.hive.druid.org.apache.druid.java.util.http.client.response.SequenceInputStreamResponseHandler;
import org.apache.hive.druid.org.jboss.netty.buffer.BigEndianHeapChannelBuffer;
import org.apache.hive.druid.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.DefaultHttpChunk;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpChunk;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponse;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.apache.hive.druid.org.jboss.netty.handler.codec.http.HttpVersion;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SequenceInputStreamResponseHandlerTest {
    private static final int TOTAL_BYTES = 1024;
    private static final ArrayList<byte[]> BYTE_LIST = new ArrayList();
    private static final Random RANDOM = new Random(378134789L);
    private static byte[] allBytes = new byte[1024];

    @BeforeClass
    public static void setUp() {
        ByteBuffer buffer = ByteBuffer.wrap(allBytes);
        while (buffer.hasRemaining()) {
            byte[] bytes = new byte[Math.min(RANDOM.nextInt(128), buffer.remaining())];
            RANDOM.nextBytes(bytes);
            buffer.put(bytes);
            BYTE_LIST.add(bytes);
        }
    }

    @AfterClass
    public static void tearDown() {
        BYTE_LIST.clear();
        allBytes = null;
    }

    private static void fillBuff(InputStream inputStream, byte[] buff) throws IOException {
        int read;
        for (int off = 0; off < buff.length; off += read) {
            read = inputStream.read(buff, off, buff.length - off);
            if (read >= 0) continue;
            throw new IOException("Unexpected end of stream");
        }
    }

    @Test(expected=TesterException.class)
    public void testExceptionalChunkedStream() throws IOException {
        Iterator<byte[]> it = BYTE_LIST.iterator();
        SequenceInputStreamResponseHandler responseHandler = new SequenceInputStreamResponseHandler();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setChunked(true);
        ClientResponse clientResponse = responseHandler.handleResponse((HttpResponse)response, null);
        final int failAt = RANDOM.nextInt(allBytes.length);
        long chunkNum = 0L;
        while (it.hasNext()) {
            DefaultHttpChunk chunk = new DefaultHttpChunk((ChannelBuffer)new BigEndianHeapChannelBuffer(it.next()){

                public void getBytes(int index, byte[] dst, int dstIndex, int length) {
                    if (dstIndex + length >= failAt) {
                        throw new TesterException();
                    }
                    super.getBytes(index, dst, dstIndex, length);
                }
            });
            clientResponse = responseHandler.handleChunk(clientResponse, (HttpChunk)chunk, ++chunkNum);
        }
        clientResponse = responseHandler.done(clientResponse);
        InputStream stream = (InputStream)clientResponse.getObj();
        byte[] buff = new byte[allBytes.length];
        SequenceInputStreamResponseHandlerTest.fillBuff(stream, buff);
    }

    @Test(expected=TesterException.class)
    public void testExceptionalSingleStream() throws IOException {
        SequenceInputStreamResponseHandler responseHandler = new SequenceInputStreamResponseHandler();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setChunked(false);
        response.setContent((ChannelBuffer)new BigEndianHeapChannelBuffer(allBytes){

            public void getBytes(int index, byte[] dst, int dstIndex, int length) {
                if (dstIndex + length >= allBytes.length) {
                    throw new TesterException();
                }
                super.getBytes(index, dst, dstIndex, length);
            }
        });
        ClientResponse clientResponse = responseHandler.handleResponse((HttpResponse)response, null);
        clientResponse = responseHandler.done(clientResponse);
        InputStream stream = (InputStream)clientResponse.getObj();
        byte[] buff = new byte[allBytes.length];
        SequenceInputStreamResponseHandlerTest.fillBuff(stream, buff);
    }

    @Test
    public void simpleMultiStreamTest() throws IOException {
        byte[] expectedBytes;
        Iterator<byte[]> it = BYTE_LIST.iterator();
        SequenceInputStreamResponseHandler responseHandler = new SequenceInputStreamResponseHandler();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setChunked(true);
        ClientResponse clientResponse = responseHandler.handleResponse((HttpResponse)response, null);
        long chunkNum = 0L;
        while (it.hasNext()) {
            DefaultHttpChunk chunk = new DefaultHttpChunk((ChannelBuffer)new BigEndianHeapChannelBuffer(it.next()));
            clientResponse = responseHandler.handleChunk(clientResponse, (HttpChunk)chunk, ++chunkNum);
        }
        clientResponse = responseHandler.done(clientResponse);
        InputStream stream = (InputStream)clientResponse.getObj();
        ByteArrayInputStream expectedStream = new ByteArrayInputStream(allBytes);
        for (int read = 0; read < allBytes.length; read += expectedBytes.length) {
            expectedBytes = new byte[Math.min(RANDOM.nextInt(128), allBytes.length - read)];
            byte[] actualBytes = new byte[expectedBytes.length];
            SequenceInputStreamResponseHandlerTest.fillBuff(stream, actualBytes);
            SequenceInputStreamResponseHandlerTest.fillBuff(expectedStream, expectedBytes);
            Assert.assertArrayEquals((byte[])expectedBytes, (byte[])actualBytes);
        }
        Assert.assertEquals((long)allBytes.length, (long)responseHandler.getByteCount());
    }

    @Test
    public void alignedMultiStreamTest() throws IOException {
        Iterator<byte[]> it = BYTE_LIST.iterator();
        SequenceInputStreamResponseHandler responseHandler = new SequenceInputStreamResponseHandler();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setChunked(true);
        ClientResponse clientResponse = responseHandler.handleResponse((HttpResponse)response, null);
        long chunkNum = 0L;
        while (it.hasNext()) {
            DefaultHttpChunk chunk = new DefaultHttpChunk((ChannelBuffer)new BigEndianHeapChannelBuffer(it.next()));
            clientResponse = responseHandler.handleChunk(clientResponse, (HttpChunk)chunk, ++chunkNum);
        }
        clientResponse = responseHandler.done(clientResponse);
        InputStream stream = (InputStream)clientResponse.getObj();
        ByteArrayInputStream expectedStream = new ByteArrayInputStream(allBytes);
        for (byte[] bytes : BYTE_LIST) {
            byte[] expectedBytes = new byte[bytes.length];
            byte[] actualBytes = new byte[expectedBytes.length];
            SequenceInputStreamResponseHandlerTest.fillBuff(stream, actualBytes);
            SequenceInputStreamResponseHandlerTest.fillBuff(expectedStream, expectedBytes);
            Assert.assertArrayEquals((byte[])expectedBytes, (byte[])actualBytes);
            Assert.assertArrayEquals((byte[])expectedBytes, (byte[])bytes);
        }
        Assert.assertEquals((long)allBytes.length, (long)responseHandler.getByteCount());
    }

    @Test
    public void simpleSingleStreamTest() throws IOException {
        byte[] expectedBytes;
        SequenceInputStreamResponseHandler responseHandler = new SequenceInputStreamResponseHandler();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setChunked(false);
        response.setContent((ChannelBuffer)new BigEndianHeapChannelBuffer(allBytes));
        ClientResponse clientResponse = responseHandler.handleResponse((HttpResponse)response, null);
        clientResponse = responseHandler.done(clientResponse);
        InputStream stream = (InputStream)clientResponse.getObj();
        ByteArrayInputStream expectedStream = new ByteArrayInputStream(allBytes);
        for (int read = 0; read < allBytes.length; read += expectedBytes.length) {
            expectedBytes = new byte[Math.min(RANDOM.nextInt(128), allBytes.length - read)];
            byte[] actualBytes = new byte[expectedBytes.length];
            SequenceInputStreamResponseHandlerTest.fillBuff(stream, actualBytes);
            SequenceInputStreamResponseHandlerTest.fillBuff(expectedStream, expectedBytes);
            Assert.assertArrayEquals((byte[])expectedBytes, (byte[])actualBytes);
        }
        Assert.assertEquals((long)allBytes.length, (long)responseHandler.getByteCount());
    }

    public static class TesterException
    extends RuntimeException {
    }
}

