/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.emitter.core;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.primitives.Ints;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.BaseHttpEmittingConfig;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.Batch;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.BatchingStrategy;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.EmitterTest;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.Event;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.GoHandler;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.GoHandlers;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.HttpEmitterConfig;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.HttpPostEmitter;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.IntEvent;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.MockHttpClient;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HttpEmitterTest {
    private final MockHttpClient httpClient = new MockHttpClient();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(){

        public byte[] writeValueAsBytes(Object value) {
            return Ints.toByteArray((int)((IntEvent)value).index);
        }
    };
    private final AtomicLong timeoutUsed = new AtomicLong();

    @Before
    public void setup() {
        this.timeoutUsed.set(-1L);
        this.httpClient.setGoHandler(new GoHandler(){

            @Override
            protected ListenableFuture<Response> go(Request request) {
                int timeout = request.getRequestTimeout();
                HttpEmitterTest.this.timeoutUsed.set(timeout);
                return GoHandlers.immediateFuture(EmitterTest.okResponse());
            }
        });
    }

    @Test
    public void timeoutEmptyQueue() throws IOException, InterruptedException {
        float timeoutAllowanceFactor = 2.0f;
        HttpEmitterConfig config = new HttpEmitterConfig.Builder("http://foo.bar").setBatchingStrategy(BatchingStrategy.ONLY_EVENTS).setHttpTimeoutAllowanceFactor(timeoutAllowanceFactor).setFlushTimeout(BaseHttpEmittingConfig.TEST_FLUSH_TIMEOUT_MILLIS).build();
        HttpPostEmitter emitter = new HttpPostEmitter(config, (AsyncHttpClient)this.httpClient, OBJECT_MAPPER);
        long startMs = System.currentTimeMillis();
        emitter.start();
        emitter.emitAndReturnBatch((Event)new IntEvent());
        emitter.flush();
        long fillTimeMs = System.currentTimeMillis() - startMs;
        Assert.assertThat((Object)this.timeoutUsed.get(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf((double)fillTimeMs * ((double)timeoutAllowanceFactor + 0.5))));
        startMs = System.currentTimeMillis();
        Batch batch = emitter.emitAndReturnBatch((Event)new IntEvent());
        Thread.sleep(1000L);
        batch.seal();
        emitter.flush();
        fillTimeMs = System.currentTimeMillis() - startMs;
        Assert.assertThat((Object)this.timeoutUsed.get(), (Matcher)Matchers.lessThan((Comparable)Double.valueOf((double)fillTimeMs * ((double)timeoutAllowanceFactor + 0.5))));
    }
}

