/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.emitter.core;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.emitter.core.GoHandler;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.Response;

public class GoHandlers {
    public static GoHandler failingHandler() {
        return new GoHandler(){

            @Override
            protected ListenableFuture<Response> go(Request request) {
                throw new ISE("Shouldn't be called", new Object[0]);
            }
        };
    }

    public static GoHandler passingHandler(final Response retVal) {
        return new GoHandler(){

            @Override
            protected ListenableFuture<Response> go(Request request) {
                return GoHandlers.immediateFuture(retVal);
            }
        };
    }

    static <T> ListenableFuture<T> immediateFuture(T val) {
        final CompletableFuture<T> future = CompletableFuture.completedFuture(val);
        return new ListenableFuture<T>(){

            public void done() {
            }

            public void abort(Throwable t) {
            }

            public void touch() {
            }

            public ListenableFuture<T> addListener(Runnable listener, Executor exec) {
                future.thenAcceptAsync(r -> listener.run(), exec);
                return this;
            }

            public CompletableFuture<T> toCompletableFuture() {
                return future;
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            public boolean isCancelled() {
                return false;
            }

            public boolean isDone() {
                return true;
            }

            public T get() throws InterruptedException, ExecutionException {
                return future.get();
            }

            public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return future.get(timeout, unit);
            }
        };
    }
}

