/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.parsers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.apache.hive.druid.com.google.common.base.Optional;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.RegexParser;
import org.junit.Test;

public class RegexParserTest {
    @Test
    public void testAWSLog() {
        String pattern = "^([0-9a-f]+) ([\\w.-]+) \\[([\\w\\/: +-]+)\\] ([\\d.]+) ([^\\s]+) ([\\w]+) ([\\w.-]+) ([^\\s\"]+) \"([^\"]*)\" ([\\d-]+) ([\\w-]+) ([\\d-]+) ([\\d-]+) ([\\d-]+) ([\\d-]+) \"(.+)\" \"(.+)\" ([\\w-]+)$";
        List<String> fieldNames = Arrays.asList("Bucket Owner", "Bucket", "Time", "Remote IP", "Requester", "Request ID", "Operation", "Key", "Request-URI", "HTTP status", "Error Code", "Bytes Sent", "Object Size", "Total Time", "Turn-Around Time", "Referrer", "User-Agent", "Version ID");
        RegexParser parser = new RegexParser("^([0-9a-f]+) ([\\w.-]+) \\[([\\w\\/: +-]+)\\] ([\\d.]+) ([^\\s]+) ([\\w]+) ([\\w.-]+) ([^\\s\"]+) \"([^\"]*)\" ([\\d-]+) ([\\w-]+) ([\\d-]+) ([\\d-]+) ([\\d-]+) ([\\d-]+) \"(.+)\" \"(.+)\" ([\\w-]+)$", Optional.absent(), fieldNames);
        String data = "79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be mybucket [06/Feb/2014:00:00:38 +0000] 192.0.2.3 79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be 3E57427F3EXAMPLE REST.GET.VERSIONING - \"GET /mybucket?versioning HTTP/1.1\" 200 - 113 - 7 - \"-\" \"S3Console/0.4\" -";
        Map parsed = parser.parseToMap(data);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"Bucket Owner", (Object)"79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be");
        builder.put((Object)"Bucket", (Object)"mybucket");
        builder.put((Object)"Time", (Object)"06/Feb/2014:00:00:38 +0000");
        builder.put((Object)"Remote IP", (Object)"192.0.2.3");
        builder.put((Object)"Requester", (Object)"79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be");
        builder.put((Object)"Request ID", (Object)"3E57427F3EXAMPLE");
        builder.put((Object)"Operation", (Object)"REST.GET.VERSIONING");
        builder.put((Object)"Key", (Object)"-");
        builder.put((Object)"Request-URI", (Object)"GET /mybucket?versioning HTTP/1.1");
        builder.put((Object)"HTTP status", (Object)"200");
        builder.put((Object)"Error Code", (Object)"-");
        builder.put((Object)"Bytes Sent", (Object)"113");
        builder.put((Object)"Object Size", (Object)"-");
        builder.put((Object)"Total Time", (Object)"7");
        builder.put((Object)"Turn-Around Time", (Object)"-");
        builder.put((Object)"Referrer", (Object)"-");
        builder.put((Object)"User-Agent", (Object)"S3Console/0.4");
        builder.put((Object)"Version ID", (Object)"-");
        Assert.assertEquals((String)"result", (Object)builder.build(), (Object)parsed);
    }

    @Test
    public void testAWSLogWithCrazyUserAgent() {
        String pattern = "^([0-9a-f]+) ([\\w.-]+) \\[([\\w\\/: +-]+)\\] ([\\d.]+) ([^\\s]+) ([\\w]+) ([\\w.-]+) ([^\\s\"]+) \"([^\"]*)\" ([\\d-]+) ([\\w-]+) ([\\d-]+) ([\\d-]+) ([\\d-]+) ([\\d-]+) \"(.+)\" \"(.+)\" ([\\w-]+)$";
        List<String> fieldNames = Arrays.asList("Bucket Owner", "Bucket", "Time", "Remote IP", "Requester", "Request ID", "Operation", "Key", "Request-URI", "HTTP status", "Error Code", "Bytes Sent", "Object Size", "Total Time", "Turn-Around Time", "Referrer", "User-Agent", "Version ID");
        RegexParser parser = new RegexParser("^([0-9a-f]+) ([\\w.-]+) \\[([\\w\\/: +-]+)\\] ([\\d.]+) ([^\\s]+) ([\\w]+) ([\\w.-]+) ([^\\s\"]+) \"([^\"]*)\" ([\\d-]+) ([\\w-]+) ([\\d-]+) ([\\d-]+) ([\\d-]+) ([\\d-]+) \"(.+)\" \"(.+)\" ([\\w-]+)$", Optional.absent(), fieldNames);
        String data = "79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be mybucket [06/Feb/2014:00:01:00 +0000] 192.0.2.3 79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be 7B4A0FABBEXAMPLE REST.GET.VERSIONING - \"GET /mybucket?versioning HTTP/1.1\" 200 - 139 139 27 26 \"-\" \"() { foo;};echo; /bin/bash -c \"expr 299663299665 / 3; echo 333:; uname -a; echo 333:; id;\"\" -";
        Map parsed = parser.parseToMap(data);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"Bucket Owner", (Object)"79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be");
        builder.put((Object)"Bucket", (Object)"mybucket");
        builder.put((Object)"Time", (Object)"06/Feb/2014:00:01:00 +0000");
        builder.put((Object)"Remote IP", (Object)"192.0.2.3");
        builder.put((Object)"Requester", (Object)"79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be");
        builder.put((Object)"Request ID", (Object)"7B4A0FABBEXAMPLE");
        builder.put((Object)"Operation", (Object)"REST.GET.VERSIONING");
        builder.put((Object)"Key", (Object)"-");
        builder.put((Object)"Request-URI", (Object)"GET /mybucket?versioning HTTP/1.1");
        builder.put((Object)"HTTP status", (Object)"200");
        builder.put((Object)"Error Code", (Object)"-");
        builder.put((Object)"Bytes Sent", (Object)"139");
        builder.put((Object)"Object Size", (Object)"139");
        builder.put((Object)"Total Time", (Object)"27");
        builder.put((Object)"Turn-Around Time", (Object)"26");
        builder.put((Object)"Referrer", (Object)"-");
        builder.put((Object)"User-Agent", (Object)"() { foo;};echo; /bin/bash -c \"expr 299663299665 / 3; echo 333:; uname -a; echo 333:; id;\"");
        builder.put((Object)"Version ID", (Object)"-");
        Assert.assertEquals((String)"result", (Object)builder.build(), (Object)parsed);
    }

    @Test
    public void testMultiVal() {
        String pattern = "^([0-9a-f]+) (.*)";
        List<String> fieldNames = Arrays.asList("Bucket Owner", "Bucket");
        RegexParser parser = new RegexParser("^([0-9a-f]+) (.*)", Optional.of((Object)"@"), fieldNames);
        String data = "79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be mybucket@mybucket2";
        Map parsed = parser.parseToMap(data);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"Bucket Owner", (Object)"79a59df900b949e55d96a1e698fbacedfd6e09d98eacf8f8d5218e7cd47ef2be");
        builder.put((Object)"Bucket", (Object)Lists.newArrayList((Object[])new String[]{"mybucket", "mybucket2"}));
        Assert.assertEquals((String)"result", (Object)builder.build(), (Object)parsed);
    }

    @Test
    public void testMultiValWithRegexSplit() {
        String pattern = "(.*)";
        String listPattern = "[a-f]";
        RegexParser parser = new RegexParser("(.*)", Optional.of((Object)"[a-f]"));
        String data = "1a2";
        Map parsed = parser.parseToMap(data);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"column_1", (Object)Lists.newArrayList((Object[])new String[]{"1", "2"}));
        Assert.assertEquals((String)"result", (Object)builder.build(), (Object)parsed);
    }

    @Test(expected=ParseException.class)
    public void testFailure() {
        String pattern = "AAAAA";
        List<String> fieldNames = Collections.singletonList("dummy");
        RegexParser parser = new RegexParser("AAAAA", Optional.of((Object)"@"), fieldNames);
        String data = "BBBB";
        parser.parseToMap(data);
    }
}

