/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.parsers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hive.druid.org.apache.druid.java.util.common.CloseableIterators;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.junit.Assert;
import org.junit.Test;

public class CloseableIteratorTest {
    @Test
    public void testMap() {
        CloseableIterator actual = CloseableIteratorTest.generateTestIterator(8).map(list -> {
            ArrayList<Integer> newList = new ArrayList<Integer>(list.size());
            for (Integer i : list) {
                newList.add(i * 10);
            }
            return newList;
        });
        Iterator expected = IntStream.range(0, 8).mapToObj(i -> IntStream.range(0, i).map(j -> j * 10).boxed().collect(Collectors.toList())).iterator();
        while (expected.hasNext() && actual.hasNext()) {
            Assert.assertEquals(expected.next(), (Object)actual.next());
        }
        Assert.assertFalse((boolean)actual.hasNext());
        Assert.assertFalse((boolean)expected.hasNext());
    }

    @Test
    public void testFlatMap() {
        CloseableIterator actual = CloseableIteratorTest.generateTestIterator(8).flatMap(list -> CloseableIterators.withEmptyBaggage(list.iterator()));
        PrimitiveIterator.OfInt expected = IntStream.range(0, 8).flatMap(i -> IntStream.range(0, i)).iterator();
        while (expected.hasNext() && actual.hasNext()) {
            Assert.assertEquals(expected.next(), (Object)actual.next());
        }
        Assert.assertFalse((boolean)actual.hasNext());
        Assert.assertFalse((boolean)expected.hasNext());
    }

    private static CloseableIterator<List<Integer>> generateTestIterator(final int numIterates) {
        return new CloseableIterator<List<Integer>>(){
            private int cnt = 0;

            public boolean hasNext() {
                return this.cnt < numIterates;
            }

            public List<Integer> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                List<Integer> integers = IntStream.range(0, this.cnt).boxed().collect(Collectors.toList());
                ++this.cnt;
                return integers;
            }

            public void close() {
            }
        };
    }
}

