/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.com.google.common.util.concurrent.Futures;
import org.apache.hive.druid.com.google.common.util.concurrent.ListenableFuture;
import org.apache.hive.druid.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hive.druid.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.junit.Assert;
import org.junit.Test;

public class LifecycleTest {
    private static final Lifecycle.Handler DUMMY_HANDLER = new Lifecycle.Handler(){

        public void start() {
        }

        public void stop() {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentStartStopOnce() throws Exception {
        int numThreads = 10;
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10));
        Lifecycle lifecycle = new Lifecycle();
        final AtomicLong handlerFailedCount = new AtomicLong(0L);
        Lifecycle.Handler exceptionalHandler = new Lifecycle.Handler(){
            final AtomicBoolean started = new AtomicBoolean(false);

            public void start() {
                if (!this.started.compareAndSet(false, true)) {
                    handlerFailedCount.incrementAndGet();
                    throw new ISE("Already started", new Object[0]);
                }
            }

            public void stop() {
                if (!this.started.compareAndSet(true, false)) {
                    handlerFailedCount.incrementAndGet();
                    throw new ISE("Not yet started started", new Object[0]);
                }
            }
        };
        lifecycle.addHandler(exceptionalHandler);
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(10);
        AtomicBoolean threadsStartLatch = new AtomicBoolean(false);
        AtomicInteger threadFailedCount = new AtomicInteger(0);
        for (int i = 0; i < 10; ++i) {
            futures.add(executorService.submit(() -> {
                try {
                    while (!threadsStartLatch.get()) {
                    }
                    lifecycle.start();
                }
                catch (Exception e) {
                    threadFailedCount.incrementAndGet();
                }
            }));
        }
        try {
            threadsStartLatch.set(true);
            Futures.allAsList(futures).get();
        }
        finally {
            lifecycle.stop();
        }
        Assert.assertEquals((long)9L, (long)threadFailedCount.get());
        Assert.assertEquals((long)0L, (long)handlerFailedCount.get());
        executorService.shutdownNow();
    }

    @Test
    public void testStartStopOnce() throws Exception {
        Lifecycle lifecycle = new Lifecycle();
        final AtomicLong failedCount = new AtomicLong(0L);
        Lifecycle.Handler exceptionalHandler = new Lifecycle.Handler(){
            final AtomicBoolean started = new AtomicBoolean(false);

            public void start() {
                if (!this.started.compareAndSet(false, true)) {
                    failedCount.incrementAndGet();
                    throw new ISE("Already started", new Object[0]);
                }
            }

            public void stop() {
                if (!this.started.compareAndSet(true, false)) {
                    failedCount.incrementAndGet();
                    throw new ISE("Not yet started started", new Object[0]);
                }
            }
        };
        lifecycle.addHandler(exceptionalHandler);
        lifecycle.start();
        lifecycle.stop();
        lifecycle.stop();
        lifecycle.stop();
        Assert.assertEquals((long)0L, (long)failedCount.get());
        Exception ex = null;
        try {
            exceptionalHandler.stop();
        }
        catch (Exception e) {
            ex = e;
        }
        Assert.assertNotNull((String)"Should have exception", (Object)ex);
    }

    @Test
    public void testSanity() throws Exception {
        Lifecycle lifecycle = new Lifecycle();
        ArrayList<Integer> startOrder = new ArrayList<Integer>();
        ArrayList<Integer> stopOrder = new ArrayList<Integer>();
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(0, startOrder, stopOrder));
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(1, startOrder, stopOrder), Lifecycle.Stage.NORMAL);
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(2, startOrder, stopOrder), Lifecycle.Stage.NORMAL);
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(3, startOrder, stopOrder), Lifecycle.Stage.ANNOUNCEMENTS);
        lifecycle.addStartCloseInstance((Object)new ObjectToBeLifecycled(4, startOrder, stopOrder));
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(5, startOrder, stopOrder));
        lifecycle.addStartCloseInstance((Object)new ObjectToBeLifecycled(6, startOrder, stopOrder), Lifecycle.Stage.ANNOUNCEMENTS);
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(7, startOrder, stopOrder));
        lifecycle.addStartCloseInstance((Object)new ObjectToBeLifecycled(8, startOrder, stopOrder), Lifecycle.Stage.INIT);
        lifecycle.addStartCloseInstance((Object)new ObjectToBeLifecycled(9, startOrder, stopOrder), Lifecycle.Stage.SERVER);
        List<Integer> expectedOrder = Arrays.asList(8, 0, 1, 2, 4, 5, 7, 9, 3, 6);
        lifecycle.start();
        Assert.assertEquals((long)10L, (long)startOrder.size());
        Assert.assertEquals((long)0L, (long)stopOrder.size());
        Assert.assertEquals(expectedOrder, startOrder);
        lifecycle.stop();
        Assert.assertEquals((long)10L, (long)startOrder.size());
        Assert.assertEquals((long)10L, (long)stopOrder.size());
        Assert.assertEquals((Object)Lists.reverse(expectedOrder), stopOrder);
    }

    @Test
    public void testAddToLifecycleInStartMethod() throws Exception {
        final Lifecycle lifecycle = new Lifecycle();
        final ArrayList<Integer> startOrder = new ArrayList<Integer>();
        final ArrayList<Integer> stopOrder = new ArrayList<Integer>();
        lifecycle.addManagedInstance((Object)new ObjectToBeLifecycled(0, startOrder, stopOrder));
        lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() throws Exception {
                lifecycle.addMaybeStartManagedInstance((Object)new ObjectToBeLifecycled(1, startOrder, stopOrder), Lifecycle.Stage.NORMAL);
                lifecycle.addMaybeStartManagedInstance((Object)new ObjectToBeLifecycled(2, startOrder, stopOrder), Lifecycle.Stage.INIT);
                lifecycle.addMaybeStartManagedInstance((Object)new ObjectToBeLifecycled(3, startOrder, stopOrder), Lifecycle.Stage.ANNOUNCEMENTS);
                lifecycle.addMaybeStartStartCloseInstance((Object)new ObjectToBeLifecycled(4, startOrder, stopOrder));
                lifecycle.addMaybeStartManagedInstance((Object)new ObjectToBeLifecycled(5, startOrder, stopOrder));
                lifecycle.addMaybeStartStartCloseInstance((Object)new ObjectToBeLifecycled(6, startOrder, stopOrder), Lifecycle.Stage.ANNOUNCEMENTS);
                lifecycle.addMaybeStartManagedInstance((Object)new ObjectToBeLifecycled(7, startOrder, stopOrder));
                lifecycle.addMaybeStartManagedInstance((Object)new ObjectToBeLifecycled(8, startOrder, stopOrder), Lifecycle.Stage.SERVER);
            }

            public void stop() {
            }
        });
        List<Integer> expectedOrder = Arrays.asList(0, 1, 2, 4, 5, 7, 8, 3, 6);
        List<Integer> expectedStopOrder = Arrays.asList(6, 3, 8, 7, 5, 4, 1, 0, 2);
        lifecycle.start();
        Assert.assertEquals(expectedOrder, startOrder);
        Assert.assertEquals((long)0L, (long)stopOrder.size());
        lifecycle.stop();
        Assert.assertEquals(expectedOrder, startOrder);
        Assert.assertEquals(expectedStopOrder, stopOrder);
    }

    @Test
    public void testFailAddToLifecycleDuringStopMethod() throws Exception {
        final CountDownLatch reachedStop = new CountDownLatch(1);
        final CountDownLatch stopper = new CountDownLatch(1);
        Lifecycle.Handler stoppingHandler = new Lifecycle.Handler(){

            public void start() {
            }

            public void stop() {
                reachedStop.countDown();
                try {
                    stopper.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Lifecycle lifecycle = new Lifecycle();
        lifecycle.addHandler(stoppingHandler);
        lifecycle.start();
        new Thread(() -> ((Lifecycle)lifecycle).stop()).start();
        reachedStop.await();
        try {
            lifecycle.addHandler(DUMMY_HANDLER);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot add a handler"));
        }
        try {
            lifecycle.addMaybeStartHandler(DUMMY_HANDLER);
            Assert.fail((String)"Expected exception");
        }
        catch (IllegalStateException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Cannot add a handler"));
        }
    }

    public static class ObjectToBeLifecycled {
        private final int id;
        private final List<Integer> orderOfStarts;
        private final List<Integer> orderOfStops;

        ObjectToBeLifecycled(int id, List<Integer> orderOfStarts, List<Integer> orderOfStops) {
            this.id = id;
            this.orderOfStarts = orderOfStarts;
            this.orderOfStops = orderOfStops;
        }

        @LifecycleStart
        public void start() {
            this.orderOfStarts.add(this.id);
        }

        @LifecycleStop
        public void close() {
            this.orderOfStops.add(this.id);
        }
    }
}

