/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Arrays;
import org.apache.hive.druid.org.apache.druid.java.util.common.io.NativeIO;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class NativeIOTest {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();

    @Test
    public void testChunkedCopy() throws Exception {
        File f = this.tempFolder.newFile();
        byte[] bytes = new byte[]{8, 9};
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        NativeIO.chunkedCopy((InputStream)bis, (File)f);
        byte[] data = Files.readAllBytes(f.toPath());
        Assert.assertTrue((boolean)Arrays.equals(bytes, data));
    }

    @Test(expected=IOException.class)
    public void testException() throws Exception {
        File dir = this.tempFolder.newFolder();
        NativeIO.chunkedCopy(null, (File)dir);
    }

    @Test
    public void testDisabledFadviseChunkedCopy() throws Exception {
        boolean possible = NativeIO.isFadvisePossible();
        NativeIO.setFadvisePossible((boolean)false);
        File f = this.tempFolder.newFile();
        byte[] bytes = new byte[]{8, 9};
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        NativeIO.chunkedCopy((InputStream)bis, (File)f);
        byte[] data = Files.readAllBytes(f.toPath());
        NativeIO.setFadvisePossible((boolean)possible);
        Assert.assertTrue((boolean)Arrays.equals(bytes, data));
    }

    @Test
    public void testDisabledSyncFileRangePossible() throws Exception {
        boolean possible = NativeIO.isSyncFileRangePossible();
        NativeIO.setSyncFileRangePossible((boolean)false);
        File f = this.tempFolder.newFile();
        byte[] bytes = new byte[]{8, 9};
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        NativeIO.chunkedCopy((InputStream)bis, (File)f);
        byte[] data = Files.readAllBytes(f.toPath());
        NativeIO.setSyncFileRangePossible((boolean)possible);
        Assert.assertTrue((boolean)Arrays.equals(bytes, data));
    }
}

