/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.guava;

import java.io.Closeable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.SequenceTestHelper;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.UnsupportedSequence;
import org.junit.Assert;
import org.junit.Test;

public class WrappingSequenceTest {
    @Test
    public void testSanity() throws Exception {
        AtomicInteger closedCounter = new AtomicInteger(0);
        Closeable closeable = () -> closedCounter.incrementAndGet();
        List<Integer> nums = Arrays.asList(1, 2, 3, 4, 5);
        SequenceTestHelper.testAll((Sequence<Integer>)Sequences.simple(nums).withBaggage(closeable), nums);
        Assert.assertEquals((long)3L, (long)closedCounter.get());
        closedCounter.set(0);
        SequenceTestHelper.testClosed(closedCounter, (Sequence<Integer>)new UnsupportedSequence().withBaggage(closeable));
    }

    @Test
    public void testConsistentCloseOrder() {
        AtomicInteger closed1 = new AtomicInteger();
        AtomicInteger closed2 = new AtomicInteger();
        AtomicInteger counter = new AtomicInteger();
        Sequence sequence = Sequences.simple(Arrays.asList(1, 2, 3)).withBaggage(() -> closed1.set(counter.incrementAndGet())).withBaggage(() -> closed2.set(counter.incrementAndGet()));
        sequence.toList();
        Assert.assertEquals((long)1L, (long)closed1.get());
        Assert.assertEquals((long)2L, (long)closed2.get());
        Sequence yieldingSequence = sequence.limit(1L);
        yieldingSequence.toList();
        Assert.assertEquals((long)3L, (long)closed1.get());
        Assert.assertEquals((long)4L, (long)closed2.get());
    }
}

