/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.guava;

import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequence;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Sequences;
import org.junit.Assert;
import org.junit.Test;

public class WithEffectSequenceTest {
    @Test
    public void testConsistentEffectApplicationOrder() {
        AtomicInteger effect1 = new AtomicInteger();
        AtomicInteger effect2 = new AtomicInteger();
        AtomicInteger counter = new AtomicInteger();
        Sequence sequence = Sequences.simple(Arrays.asList(1, 2, 3)).withEffect(() -> effect1.set(counter.incrementAndGet()), (Executor)Execs.directExecutor()).withEffect(() -> effect2.set(counter.incrementAndGet()), (Executor)Execs.directExecutor());
        sequence.toList();
        Assert.assertEquals((long)1L, (long)effect1.get());
        Assert.assertEquals((long)2L, (long)effect2.get());
        Sequence yieldingSequence = sequence.limit(4L);
        yieldingSequence.toList();
        Assert.assertEquals((long)3L, (long)effect1.get());
        Assert.assertEquals((long)4L, (long)effect2.get());
    }

    @Test
    public void testEffectExecutedIfWrappedSequenceThrowsExceptionFromClose() {
        Sequence baseSeq = Sequences.simple(Arrays.asList(1, 2, 3));
        Sequence throwingSeq = baseSeq.withBaggage(() -> {
            throw new RuntimeException();
        });
        AtomicBoolean effectExecuted = new AtomicBoolean();
        Sequence seqWithEffect = throwingSeq.withEffect(() -> effectExecuted.set(true), (Executor)Execs.directExecutor());
        try {
            seqWithEffect.toList();
            Assert.fail((String)"expected RuntimeException");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((boolean)effectExecuted.get());
        }
    }
}

