/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common.guava;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.hive.druid.org.apache.druid.java.util.common.Intervals;
import org.apache.hive.druid.org.apache.druid.java.util.common.guava.Comparators;
import org.joda.time.Interval;
import org.junit.Assert;
import org.junit.Test;

public class ComparatorsTest {
    @Test
    public void testIntervalsByStartThenEnd() {
        Comparator comp = Comparators.intervalsByStartThenEnd();
        Assert.assertEquals((long)0L, (long)comp.compare(Intervals.of((String)"P1d/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-02")));
        Assert.assertEquals((long)-1L, (long)comp.compare(Intervals.of((String)"2011-03-31/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-02")));
        Assert.assertEquals((long)1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-03-31/2011-04-02")));
        Assert.assertEquals((long)1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-02")));
        Assert.assertEquals((long)-1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04")));
        Object[] intervals = new Interval[]{Intervals.of((String)"2011-04-01T18/2011-04-02T13"), Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04"), Intervals.of((String)"2011-04-02/2011-04-04"), Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-02/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03T06")};
        Arrays.sort(intervals, comp);
        Assert.assertArrayEquals((Object[])new Interval[]{Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04"), Intervals.of((String)"2011-04-01T18/2011-04-02T13"), Intervals.of((String)"2011-04-02/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03T06"), Intervals.of((String)"2011-04-02/2011-04-04")}, (Object[])intervals);
    }

    @Test
    public void testIntervalsByEndThenStart() {
        Comparator comp = Comparators.intervalsByEndThenStart();
        Assert.assertEquals((long)0L, (long)comp.compare(Intervals.of((String)"P1d/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-02")));
        Assert.assertEquals((long)-1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04")));
        Assert.assertEquals((long)1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-01/2011-04-01")));
        Assert.assertEquals((long)-1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03")));
        Assert.assertEquals((long)1L, (long)comp.compare(Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-03-31/2011-04-03")));
        Object[] intervals = new Interval[]{Intervals.of((String)"2011-04-01T18/2011-04-02T13"), Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-01/2011-04-04"), Intervals.of((String)"2011-04-02/2011-04-04"), Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-02/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03T06")};
        Arrays.sort(intervals, comp);
        Assert.assertArrayEquals((Object[])new Interval[]{Intervals.of((String)"2011-04-01/2011-04-02"), Intervals.of((String)"2011-04-01T18/2011-04-02T13"), Intervals.of((String)"2011-04-01/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03"), Intervals.of((String)"2011-04-02/2011-04-03T06"), Intervals.of((String)"2011-04-01/2011-04-04"), Intervals.of((String)"2011-04-02/2011-04-04")}, (Object[])intervals);
    }
}

