/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common;

import java.net.URI;
import org.apache.hive.druid.org.apache.druid.java.util.common.URIs;
import org.junit.Assert;
import org.junit.Test;

public class URIsTest {
    @Test
    public void testFullUri() {
        String strUri = "https://test-user@127.0.0.1:8000/test/path?test-query#test-fragment";
        URI uri = URIs.parse((String)"https://test-user@127.0.0.1:8000/test/path?test-query#test-fragment", (String)"http");
        Assert.assertEquals((Object)"https", (Object)uri.getScheme());
        Assert.assertEquals((Object)"test-user", (Object)uri.getUserInfo());
        Assert.assertEquals((Object)"127.0.0.1", (Object)uri.getHost());
        Assert.assertEquals((long)8000L, (long)uri.getPort());
        Assert.assertEquals((Object)"/test/path", (Object)uri.getPath());
        Assert.assertEquals((Object)"test-query", (Object)uri.getQuery());
        Assert.assertEquals((Object)"test-fragment", (Object)uri.getFragment());
    }

    @Test
    public void testWithoutScheme() {
        String strUri = "test-user@127.0.0.1:8000/test/path?test-query#test-fragment";
        URI uri = URIs.parse((String)"test-user@127.0.0.1:8000/test/path?test-query#test-fragment", (String)"http");
        Assert.assertEquals((Object)"http", (Object)uri.getScheme());
        Assert.assertEquals((Object)"test-user", (Object)uri.getUserInfo());
        Assert.assertEquals((Object)"127.0.0.1", (Object)uri.getHost());
        Assert.assertEquals((long)8000L, (long)uri.getPort());
        Assert.assertEquals((Object)"/test/path", (Object)uri.getPath());
        Assert.assertEquals((Object)"test-query", (Object)uri.getQuery());
        Assert.assertEquals((Object)"test-fragment", (Object)uri.getFragment());
    }

    @Test
    public void testSimpleUri() {
        String strUri = "127.0.0.1:8000";
        URI uri = URIs.parse((String)"127.0.0.1:8000", (String)"https");
        Assert.assertEquals((Object)"https", (Object)uri.getScheme());
        Assert.assertNull((Object)uri.getUserInfo());
        Assert.assertEquals((Object)"127.0.0.1", (Object)uri.getHost());
        Assert.assertEquals((long)8000L, (long)uri.getPort());
    }
}

