/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common;

import java.io.UnsupportedEncodingException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class StringUtilsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void fromUtf8ConversionTest() throws UnsupportedEncodingException {
        byte[] bytes = new byte[]{97, 98, 99, 100};
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((byte[])bytes));
        String abcd = "abcd";
        Assert.assertEquals((Object)abcd, (Object)StringUtils.fromUtf8((byte[])abcd.getBytes(StringUtils.UTF8_STRING)));
    }

    @Test
    public void toUtf8ConversionTest() {
        byte[] bytes = new byte[]{97, 98, 99, 100};
        byte[] strBytes = StringUtils.toUtf8((String)"abcd");
        for (int i = 0; i < bytes.length; ++i) {
            Assert.assertEquals((long)bytes[i], (long)strBytes[i]);
        }
    }

    @Test
    public void toUtf8WithLimitTest() {
        ByteBuffer smallBuffer = ByteBuffer.allocate(4);
        ByteBuffer mediumBuffer = ByteBuffer.allocate(6);
        ByteBuffer bigBuffer = ByteBuffer.allocate(8);
        int smallBufferResult = StringUtils.toUtf8WithLimit((String)"\ud83d\ude80\ud83c\udf14", (ByteBuffer)smallBuffer);
        Assert.assertEquals((long)4L, (long)smallBufferResult);
        byte[] smallBufferByteArray = new byte[smallBufferResult];
        smallBuffer.get(smallBufferByteArray);
        Assert.assertEquals((Object)"\ud83d\ude80", (Object)StringUtils.fromUtf8((byte[])smallBufferByteArray));
        int mediumBufferResult = StringUtils.toUtf8WithLimit((String)"\ud83d\ude80\ud83c\udf14", (ByteBuffer)mediumBuffer);
        Assert.assertEquals((long)4L, (long)mediumBufferResult);
        byte[] mediumBufferByteArray = new byte[mediumBufferResult];
        mediumBuffer.get(mediumBufferByteArray);
        Assert.assertEquals((Object)"\ud83d\ude80", (Object)StringUtils.fromUtf8((byte[])mediumBufferByteArray));
        int bigBufferResult = StringUtils.toUtf8WithLimit((String)"\ud83d\ude80\ud83c\udf14", (ByteBuffer)bigBuffer);
        Assert.assertEquals((long)8L, (long)bigBufferResult);
        byte[] bigBufferByteArray = new byte[bigBufferResult];
        bigBuffer.get(bigBufferByteArray);
        Assert.assertEquals((Object)"\ud83d\ude80\ud83c\udf14", (Object)StringUtils.fromUtf8((byte[])bigBufferByteArray));
    }

    @Test
    public void fromUtf8ByteBufferHeap() {
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{97, 98, 99, 100});
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((ByteBuffer)bytes, (int)4));
        bytes.rewind();
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((ByteBuffer)bytes));
    }

    @Test
    public void testMiddleOfByteArrayConversion() {
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{97, 98, 99, 100});
        bytes.position(1).limit(3);
        Assert.assertEquals((Object)"bc", (Object)StringUtils.fromUtf8((ByteBuffer)bytes, (int)2));
        bytes.position(1);
        Assert.assertEquals((Object)"bc", (Object)StringUtils.fromUtf8((ByteBuffer)bytes));
    }

    @Test(expected=BufferUnderflowException.class)
    public void testOutOfBounds() {
        ByteBuffer bytes = ByteBuffer.wrap(new byte[]{97, 98, 99, 100});
        bytes.position(1).limit(3);
        StringUtils.fromUtf8((ByteBuffer)bytes, (int)3);
    }

    @Test(expected=NullPointerException.class)
    public void testNullPointerByteBuffer() {
        StringUtils.fromUtf8((ByteBuffer)null);
    }

    @Test(expected=NullPointerException.class)
    public void testNullPointerByteArray() {
        StringUtils.fromUtf8((byte[])null);
    }

    @Test
    public void fromUtf8ByteBufferDirect() {
        ByteBuffer bytes = ByteBuffer.allocateDirect(4);
        bytes.put(new byte[]{97, 98, 99, 100});
        bytes.rewind();
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((ByteBuffer)bytes, (int)4));
        bytes.rewind();
        Assert.assertEquals((Object)"abcd", (Object)StringUtils.fromUtf8((ByteBuffer)bytes));
    }

    @Test
    public void testCharsetShowsUpAsDeprecated() {
        Assert.assertNotNull((Object)StringUtils.UTF8_CHARSET);
    }

    @Test
    public void testNonStrictFormat() {
        Assert.assertEquals((Object)"test%d; format", (Object)StringUtils.nonStrictFormat((String)"test%d", (Object[])new Object[]{"format"}));
        Assert.assertEquals((Object)"test%s%s; format", (Object)StringUtils.nonStrictFormat((String)"test%s%s", (Object[])new Object[]{"format"}));
    }

    @Test
    public void testRemoveChar() {
        Assert.assertEquals((Object)"123", (Object)StringUtils.removeChar((String)"123", (char)','));
        Assert.assertEquals((Object)"123", (Object)StringUtils.removeChar((String)"123,", (char)','));
        Assert.assertEquals((Object)"123", (Object)StringUtils.removeChar((String)",1,,2,3,", (char)','));
        Assert.assertEquals((Object)"", (Object)StringUtils.removeChar((String)",,", (char)','));
    }

    @Test
    public void testReplaceChar() {
        Assert.assertEquals((Object)"123", (Object)StringUtils.replaceChar((String)"123", (char)',', (String)"x"));
        Assert.assertEquals((Object)"12345", (Object)StringUtils.replaceChar((String)"123,", (char)',', (String)"45"));
        Assert.assertEquals((Object)"", (Object)StringUtils.replaceChar((String)"", (char)'a', (String)"bb"));
        Assert.assertEquals((Object)"bb", (Object)StringUtils.replaceChar((String)"a", (char)'a', (String)"bb"));
        Assert.assertEquals((Object)"bbbb", (Object)StringUtils.replaceChar((String)"aa", (char)'a', (String)"bb"));
    }

    @Test
    public void testReplace() {
        Assert.assertEquals((Object)"x1x2x3x", (Object)StringUtils.replace((String)"123", (String)"", (String)"x"));
        Assert.assertEquals((Object)"12345", (Object)StringUtils.replace((String)"123,", (String)",", (String)"45"));
        Assert.assertEquals((Object)"", (Object)StringUtils.replace((String)"", (String)"a", (String)"bb"));
        Assert.assertEquals((Object)"bb", (Object)StringUtils.replace((String)"a", (String)"a", (String)"bb"));
        Assert.assertEquals((Object)"bba", (Object)StringUtils.replace((String)"aaa", (String)"aa", (String)"bb"));
        Assert.assertEquals((Object)"bcb", (Object)StringUtils.replace((String)"aacaa", (String)"aa", (String)"b"));
        Assert.assertEquals((Object)"bb", (Object)StringUtils.replace((String)"aaaa", (String)"aa", (String)"b"));
        Assert.assertEquals((Object)"", (Object)StringUtils.replace((String)"aaaa", (String)"aa", (String)""));
    }

    @Test
    public void testURLEncodeSpace() {
        String s1 = StringUtils.urlEncode((String)"aaa bbb");
        Assert.assertEquals((Object)s1, (Object)"aaa%20bbb");
        Assert.assertEquals((Object)"aaa bbb", (Object)StringUtils.urlDecode((String)s1));
        String s2 = StringUtils.urlEncode((String)"fff+ggg");
        Assert.assertEquals((Object)s2, (Object)"fff%2Bggg");
        Assert.assertEquals((Object)"fff+ggg", (Object)StringUtils.urlDecode((String)s2));
    }

    @Test
    public void testRepeat() {
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"foo", (int)0));
        Assert.assertEquals((Object)"foo", (Object)StringUtils.repeat((String)"foo", (int)1));
        Assert.assertEquals((Object)"foofoofoo", (Object)StringUtils.repeat((String)"foo", (int)3));
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"", (int)0));
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"", (int)1));
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"", (int)3));
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("count is negative, -1");
        Assert.assertEquals((Object)"", (Object)StringUtils.repeat((String)"foo", (int)-1));
    }

    @Test
    public void testLpad() {
        String s1 = StringUtils.lpad((String)"abc", (Integer)7, (String)"de");
        Assert.assertEquals((Object)s1, (Object)"dedeabc");
        String s2 = StringUtils.lpad((String)"abc", (Integer)6, (String)"de");
        Assert.assertEquals((Object)s2, (Object)"dedabc");
        String s3 = StringUtils.lpad((String)"abc", (Integer)2, (String)"de");
        Assert.assertEquals((Object)s3, (Object)"ab");
        String s4 = StringUtils.lpad((String)"abc", (Integer)0, (String)"de");
        Assert.assertEquals((Object)s4, (Object)"");
        String s5 = StringUtils.lpad((String)"abc", (Integer)-1, (String)"de");
        Assert.assertEquals((Object)s5, null);
    }

    @Test
    public void testRpad() {
        String s1 = StringUtils.rpad((String)"abc", (Integer)7, (String)"de");
        Assert.assertEquals((Object)s1, (Object)"abcdede");
        String s2 = StringUtils.rpad((String)"abc", (Integer)6, (String)"de");
        Assert.assertEquals((Object)s2, (Object)"abcded");
        String s3 = StringUtils.rpad((String)"abc", (Integer)2, (String)"de");
        Assert.assertEquals((Object)s3, (Object)"ab");
        String s4 = StringUtils.rpad((String)"abc", (Integer)0, (String)"de");
        Assert.assertEquals((Object)s4, (Object)"");
        String s5 = StringUtils.rpad((String)"abc", (Integer)-1, (String)"de");
        Assert.assertEquals((Object)s5, null);
    }

    @Test
    public void testChop() {
        Assert.assertEquals((Object)"foo", (Object)StringUtils.chop((String)"foo", (int)5));
        Assert.assertEquals((Object)"fo", (Object)StringUtils.chop((String)"foo", (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.chop((String)"foo", (int)0));
        Assert.assertEquals((Object)"smile \ud83d\ude42 for", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)14));
        Assert.assertEquals((Object)"smile \ud83d\ude42", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)10));
        Assert.assertEquals((Object)"smile ", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)9));
        Assert.assertEquals((Object)"smile ", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)8));
        Assert.assertEquals((Object)"smile ", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)7));
        Assert.assertEquals((Object)"smile ", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)6));
        Assert.assertEquals((Object)"smile", (Object)StringUtils.chop((String)"smile \ud83d\ude42 for the camera", (int)5));
    }

    @Test
    public void testFastLooseChop() {
        Assert.assertEquals((Object)"foo", (Object)StringUtils.fastLooseChop((String)"foo", (int)5));
        Assert.assertEquals((Object)"fo", (Object)StringUtils.fastLooseChop((String)"foo", (int)2));
        Assert.assertEquals((Object)"", (Object)StringUtils.fastLooseChop((String)"foo", (int)0));
        Assert.assertEquals((Object)"smile \ud83d\ude42 for", (Object)StringUtils.fastLooseChop((String)"smile \ud83d\ude42 for the camera", (int)12));
        Assert.assertEquals((Object)"smile \ud83d\ude42 ", (Object)StringUtils.fastLooseChop((String)"smile \ud83d\ude42 for the camera", (int)9));
        Assert.assertEquals((Object)"smile \ud83d\ude42", (Object)StringUtils.fastLooseChop((String)"smile \ud83d\ude42 for the camera", (int)8));
        Assert.assertEquals((Object)"smile \ud83d", (Object)StringUtils.fastLooseChop((String)"smile \ud83d\ude42 for the camera", (int)7));
        Assert.assertEquals((Object)"smile ", (Object)StringUtils.fastLooseChop((String)"smile \ud83d\ude42 for the camera", (int)6));
        Assert.assertEquals((Object)"smile", (Object)StringUtils.fastLooseChop((String)"smile \ud83d\ude42 for the camera", (int)5));
    }
}

