/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.com.google.common.io.ByteSink;
import org.apache.hive.druid.com.google.common.io.ByteSource;
import org.apache.hive.druid.org.apache.druid.java.util.common.FileUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.StreamUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class StreamUtilsTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testRetryExceptionOnFlush() {
        final byte[] bytes = new byte[1024];
        Random random = new Random(47831947819L);
        random.nextBytes(bytes);
        final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        final AtomicLong outputFlushes = new AtomicLong(0L);
        Assert.assertEquals((long)bytes.length, (long)StreamUtils.retryCopy((ByteSource)new ByteSource(){

            public InputStream openStream() {
                return new ByteArrayInputStream(bytes);
            }
        }, (ByteSink)new ByteSink(){

            public OutputStream openStream() {
                byteArrayOutputStream.reset();
                return new FilterOutputStream(byteArrayOutputStream){

                    @Override
                    public void flush() throws IOException {
                        if (outputFlushes.getAndIncrement() <= 0L) {
                            throw new IOException("Test exception");
                        }
                        this.out.flush();
                    }
                };
            }
        }, (Predicate)FileUtils.IS_EXCEPTION, (int)10));
        Assert.assertEquals((long)4L, (long)outputFlushes.get());
        Assert.assertArrayEquals((byte[])bytes, (byte[])byteArrayOutputStream.toByteArray());
    }
}

