/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hive.druid.com.google.common.base.Predicate;
import org.apache.hive.druid.org.apache.druid.java.util.common.RetryUtils;
import org.junit.Assert;
import org.junit.Test;

public class RetryUtilsTest {
    private static final Predicate<Throwable> IS_TRANSIENT = new Predicate<Throwable>(){

        public boolean apply(Throwable e) {
            return e instanceof IOException && e.getMessage().equals("what");
        }
    };

    @Test
    public void testImmediateSuccess() throws Exception {
        AtomicInteger count = new AtomicInteger();
        String result = (String)RetryUtils.retry(() -> {
            count.incrementAndGet();
            return "hey";
        }, IS_TRANSIENT, (int)2);
        Assert.assertEquals((String)"result", (Object)"hey", (Object)result);
        Assert.assertEquals((String)"count", (long)1L, (long)count.get());
    }

    @Test
    public void testEventualFailure() throws Exception {
        AtomicInteger count = new AtomicInteger();
        boolean threwExpectedException = false;
        try {
            RetryUtils.retry(() -> {
                count.incrementAndGet();
                throw new IOException("what");
            }, IS_TRANSIENT, (int)2);
        }
        catch (IOException e) {
            threwExpectedException = e.getMessage().equals("what");
        }
        Assert.assertTrue((String)"threw expected exception", (boolean)threwExpectedException);
        Assert.assertEquals((String)"count", (long)2L, (long)count.get());
    }

    @Test
    public void testEventualSuccess() throws Exception {
        AtomicInteger count = new AtomicInteger();
        String result = (String)RetryUtils.retry(() -> {
            if (count.incrementAndGet() >= 2) {
                return "hey";
            }
            throw new IOException("what");
        }, IS_TRANSIENT, (int)3);
        Assert.assertEquals((String)"result", (Object)"hey", (Object)result);
        Assert.assertEquals((String)"count", (long)2L, (long)count.get());
    }

    @Test
    public void testExceptionPredicateNotMatching() throws Exception {
        AtomicInteger count = new AtomicInteger();
        boolean threwExpectedException = false;
        try {
            RetryUtils.retry(() -> {
                if (count.incrementAndGet() >= 2) {
                    return "hey";
                }
                throw new IOException("uhh");
            }, IS_TRANSIENT, (int)3);
        }
        catch (IOException e) {
            threwExpectedException = e.getMessage().equals("uhh");
        }
        Assert.assertTrue((String)"threw expected exception", (boolean)threwExpectedException);
        Assert.assertEquals((String)"count", (long)1L, (long)count.get());
    }
}

