/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common;

import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.Numbers;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class NumbersTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testParseLong() {
        String strVal = "100";
        Assert.assertEquals((long)100L, (long)Numbers.parseLong((Object)"100"));
        Long longVal = 100L;
        Assert.assertEquals((long)100L, (long)Numbers.parseLong((Object)longVal));
        Double doubleVal = 100.0;
        Assert.assertEquals((long)100L, (long)Numbers.parseLong((Object)doubleVal));
    }

    @Test
    public void testParseLongWithNull() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("Input is null");
        Numbers.parseLong(null);
    }

    @Test
    public void testParseLongWithUnparseableString() {
        this.expectedException.expect(NumberFormatException.class);
        Numbers.parseLong((Object)"unparseable");
    }

    @Test
    public void testParseLongWithUnparseableObject() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage(CoreMatchers.startsWith((String)"Unknown type"));
        Numbers.parseLong((Object)new Object());
    }

    @Test
    public void testParseInt() {
        String strVal = "100";
        Assert.assertEquals((long)100L, (long)Numbers.parseInt((Object)"100"));
        Integer longVal = 100;
        Assert.assertEquals((long)100L, (long)Numbers.parseInt((Object)longVal));
        Float floatVal = Float.valueOf(100.0f);
        Assert.assertEquals((long)100L, (long)Numbers.parseInt((Object)floatVal));
    }

    @Test
    public void testParseIntWithNull() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("Input is null");
        Numbers.parseInt(null);
    }

    @Test
    public void testParseIntWithUnparseableString() {
        this.expectedException.expect(NumberFormatException.class);
        Numbers.parseInt((Object)"unparseable");
    }

    @Test
    public void testParseIntWithUnparseableObject() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage(CoreMatchers.startsWith((String)"Unknown type"));
        Numbers.parseInt((Object)new Object());
    }

    @Test
    public void testParseBoolean() {
        String strVal = "false";
        Assert.assertEquals((Object)false, (Object)Numbers.parseBoolean((Object)"false"));
        Boolean booleanVal = Boolean.FALSE;
        Assert.assertEquals((Object)false, (Object)Numbers.parseBoolean((Object)booleanVal));
    }

    @Test
    public void testParseBooleanWithNull() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("Input is null");
        Numbers.parseBoolean(null);
    }

    @Test
    public void testParseBooleanWithUnparseableObject() {
        this.expectedException.expect(ISE.class);
        this.expectedException.expectMessage(CoreMatchers.startsWith((String)"Unknown type"));
        Numbers.parseBoolean((Object)new Object());
    }
}

