/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import org.apache.hive.druid.org.apache.druid.java.util.common.BufferUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.FileUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.java.util.common.MappedByteBufferHandler;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.rules.TemporaryFolder;

public class FileUtilsTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testMap() throws IOException {
        File dataFile = this.folder.newFile("data");
        long buffersMemoryBefore = BufferUtils.totalMemoryUsedByDirectAndMappedBuffers();
        try (RandomAccessFile raf = new RandomAccessFile(dataFile, "rw");){
            raf.write(42);
            raf.setLength(0x100000L);
        }
        var5_5 = null;
        try (MappedByteBufferHandler mappedByteBufferHandler = FileUtils.map((File)dataFile);){
            Assert.assertEquals((long)42L, (long)mappedByteBufferHandler.get().get(0));
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        long buffersMemoryAfter = BufferUtils.totalMemoryUsedByDirectAndMappedBuffers();
        Assert.assertEquals((long)buffersMemoryBefore, (long)buffersMemoryAfter);
    }

    @Test
    public void testWriteAtomically() throws IOException {
        File tmpDir = this.folder.newFolder();
        File tmpFile = new File(tmpDir, "file1");
        FileUtils.writeAtomically((File)tmpFile, out -> {
            out.write(StringUtils.toUtf8((String)"foo"));
            return null;
        });
        Assert.assertEquals((Object)"foo", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(tmpFile.toPath())));
        try {
            FileUtils.writeAtomically((File)tmpFile, out -> {
                out.write(StringUtils.toUtf8((String)"bar"));
                out.flush();
                throw new ISE("OMG!", new Object[0]);
            });
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertEquals((Object)"foo", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(tmpFile.toPath())));
        FileUtils.writeAtomically((File)tmpFile, out -> {
            out.write(StringUtils.toUtf8((String)"baz"));
            return null;
        });
        Assert.assertEquals((Object)"baz", (Object)StringUtils.fromUtf8((byte[])Files.readAllBytes(tmpFile.toPath())));
    }

    @Test
    public void testCreateTempDir() throws IOException {
        File tempDir = FileUtils.createTempDir();
        try {
            Assert.assertEquals((Object)new File(System.getProperty("java.io.tmpdir")).toPath(), (Object)tempDir.getParentFile().toPath());
        }
        finally {
            Files.delete(tempDir.toPath());
        }
    }

    @Test
    public void testCreateTempDirNonexistentBase() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("java.io.tmpdir (/nonexistent) does not exist");
        String oldJavaTmpDir = System.getProperty("java.io.tmpdir");
        try {
            System.setProperty("java.io.tmpdir", "/nonexistent");
            FileUtils.createTempDir();
        }
        finally {
            System.setProperty("java.io.tmpdir", oldJavaTmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateTempDirUnwritableBase() throws IOException {
        File baseDir = FileUtils.createTempDir();
        try {
            this.expectedException.expect(IllegalStateException.class);
            this.expectedException.expectMessage("java.io.tmpdir (" + baseDir + ") is not writable");
            String oldJavaTmpDir = System.getProperty("java.io.tmpdir");
            try {
                System.setProperty("java.io.tmpdir", baseDir.getPath());
                baseDir.setWritable(false);
                FileUtils.createTempDir();
            }
            finally {
                System.setProperty("java.io.tmpdir", oldJavaTmpDir);
            }
        }
        finally {
            baseDir.setWritable(true);
            Files.delete(baseDir.toPath());
        }
    }
}

