/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common;

import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class DateTimesTest {
    @Test
    public void testCommonDateTimePattern() {
        DateTime dt1 = DateTimes.nowUtc();
        DateTime dt2 = new DateTime(System.currentTimeMillis(), DateTimes.inferTzFromString((String)"IST"));
        DateTime dt3 = new DateTime(System.currentTimeMillis(), DateTimeZone.forOffsetHoursMinutes((int)1, (int)30));
        for (DateTime dt : new DateTime[]{dt1, dt2, dt3}) {
            Assert.assertTrue((boolean)DateTimes.COMMON_DATE_TIME_PATTERN.matcher(dt.toString()).matches());
        }
    }

    @Test
    public void testStringToDateTimeConversion() {
        String seconds = "2018-01-30T06:00:00";
        DateTime dt2 = DateTimes.of((String)seconds);
        Assert.assertEquals((Object)"2018-01-30T06:00:00.000Z", (Object)dt2.toString());
        String milis = "1517292000000";
        DateTime dt1 = DateTimes.of((String)milis);
        Assert.assertEquals((Object)"2018-01-30T06:00:00.000Z", (Object)dt1.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStringToDateTimeConverstion_RethrowInitialException() {
        String invalid = "51729200AZ";
        DateTimes.of((String)invalid);
    }
}

