/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.java.util.common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.hive.druid.com.google.common.io.Files;
import org.apache.hive.druid.org.apache.druid.java.util.common.ByteBufferUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ByteBufferUtilsTest {
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testUnmapDoesntCrashJVM() throws Exception {
        File file = this.temporaryFolder.newFile("some_mmap_file");
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            byte[] data = new byte[4096];
            Arrays.fill(data, (byte)90);
            ((OutputStream)os).write(data);
        }
        MappedByteBuffer mappedByteBuffer = Files.map((File)file);
        Assert.assertEquals((byte)90, (byte)mappedByteBuffer.get(0));
        ByteBufferUtils.unmap((MappedByteBuffer)mappedByteBuffer);
        ByteBufferUtils.unmap((MappedByteBuffer)mappedByteBuffer);
    }

    @Test
    public void testFreeDoesntCrashJVM() {
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(4096);
        ByteBufferUtils.free((ByteBuffer)directBuffer);
        ByteBufferUtils.free((ByteBuffer)directBuffer);
        ByteBuffer heapBuffer = ByteBuffer.allocate(4096);
        ByteBufferUtils.free((ByteBuffer)heapBuffer);
    }
}

