/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.initialization;

import com.google.inject.Key;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import org.apache.curator.utils.ZKPaths;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigTesterBase;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigurator;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Json;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.server.initialization.ZkPathsConfig;
import org.junit.Assert;
import org.junit.Test;

public class ZkPathsConfigTest
extends JsonConfigTesterBase<ZkPathsConfig> {
    @Test
    public void testOverrideBaseOnlyConfig() throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, IOException {
        JsonConfigurator configurator = (JsonConfigurator)this.injector.getBinding(JsonConfigurator.class).getProvider().get();
        JsonConfigProvider zkPathsConfig = JsonConfigProvider.of((String)"druid.test.prefix", ZkPathsConfig.class);
        this.testProperties.clear();
        String base = UUID.randomUUID().toString();
        this.testProperties.put(StringUtils.format((String)"%s.base", (Object[])new Object[]{"druid.test.prefix"}), base);
        zkPathsConfig.inject(this.testProperties, configurator);
        this.propertyValues.clear();
        this.propertyValues.put(StringUtils.format((String)"%s.base", (Object[])new Object[]{"druid.test.prefix"}), base);
        this.propertyValues.put(StringUtils.format((String)"%s.propertiesPath", (Object[])new Object[]{"druid.test.prefix"}), ZKPaths.makePath((String)base, (String)"properties"));
        this.propertyValues.put(StringUtils.format((String)"%s.announcementsPath", (Object[])new Object[]{"druid.test.prefix"}), ZKPaths.makePath((String)base, (String)"announcements"));
        this.propertyValues.put(StringUtils.format((String)"%s.servedSegmentsPath", (Object[])new Object[]{"druid.test.prefix"}), ZKPaths.makePath((String)base, (String)"servedSegments"));
        this.propertyValues.put(StringUtils.format((String)"%s.liveSegmentsPath", (Object[])new Object[]{"druid.test.prefix"}), ZKPaths.makePath((String)base, (String)"segments"));
        this.propertyValues.put(StringUtils.format((String)"%s.coordinatorPath", (Object[])new Object[]{"druid.test.prefix"}), ZKPaths.makePath((String)base, (String)"coordinator"));
        this.propertyValues.put(StringUtils.format((String)"%s.loadQueuePath", (Object[])new Object[]{"druid.test.prefix"}), ZKPaths.makePath((String)base, (String)"loadQueue"));
        this.propertyValues.put(StringUtils.format((String)"%s.connectorPath", (Object[])new Object[]{"druid.test.prefix"}), ZKPaths.makePath((String)base, (String)"connector"));
        ZkPathsConfig zkPathsConfigObj = (ZkPathsConfig)zkPathsConfig.get().get();
        this.validateEntries(zkPathsConfigObj);
        Assert.assertEquals((long)this.propertyValues.size(), (long)this.assertions);
        ObjectMapper jsonMapper = (ObjectMapper)this.injector.getProvider(Key.get(ObjectMapper.class, Json.class)).get();
        String jsonVersion = jsonMapper.writeValueAsString((Object)zkPathsConfigObj);
        ZkPathsConfig zkPathsConfigObjDeSer = (ZkPathsConfig)jsonMapper.readValue(jsonVersion, ZkPathsConfig.class);
        Assert.assertEquals((Object)zkPathsConfigObj, (Object)zkPathsConfigObjDeSer);
    }
}

