/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.initialization;

import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.base.Function;
import org.apache.hive.druid.com.google.common.collect.Collections2;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Sets;
import org.apache.hive.druid.org.apache.druid.guice.ExtensionsConfig;
import org.apache.hive.druid.org.apache.druid.guice.GuiceInjectors;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.annotations.Self;
import org.apache.hive.druid.org.apache.druid.initialization.DruidModule;
import org.apache.hive.druid.org.apache.druid.initialization.Initialization;
import org.apache.hive.druid.org.apache.druid.java.util.common.ISE;
import org.apache.hive.druid.org.apache.druid.server.DruidNode;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class InitializationTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void test01InitialModulesEmpty() {
        Initialization.clearLoadedImplementations();
        Assert.assertEquals((String)"Initial set of loaded modules must be empty", (long)0L, (long)Initialization.getLoadedImplementations(DruidModule.class).size());
    }

    @Test
    public void test02MakeStartupInjector() {
        Injector startupInjector = GuiceInjectors.makeStartupInjector();
        Assert.assertNotNull((Object)startupInjector);
        Assert.assertNotNull((Object)startupInjector.getInstance(ObjectMapper.class));
    }

    @Test
    public void test03ClassLoaderExtensionsLoading() {
        Injector startupInjector = GuiceInjectors.makeStartupInjector();
        Function<DruidModule, String> fnClassName = new Function<DruidModule, String>(){

            @Nullable
            public String apply(@Nullable DruidModule input) {
                return input.getClass().getName();
            }
        };
        Assert.assertFalse((String)"modules does not contain TestDruidModule", (boolean)Collections2.transform((Collection)Initialization.getLoadedImplementations(DruidModule.class), (Function)fnClassName).contains("org.apache.hive.druid.org.apache.druid.initialization.InitializationTest.TestDruidModule"));
        Collection modules = Initialization.getFromExtensions((ExtensionsConfig)((ExtensionsConfig)startupInjector.getInstance(ExtensionsConfig.class)), DruidModule.class);
        Assert.assertTrue((String)"modules contains TestDruidModule", (boolean)Collections2.transform((Collection)modules, (Function)fnClassName).contains(TestDruidModule.class.getName()));
    }

    @Test
    public void test04DuplicateClassLoaderExtensions() throws Exception {
        File extensionDir = this.temporaryFolder.newFolder();
        Initialization.getLoadersMap().put(extensionDir, new URLClassLoader(new URL[0], Initialization.class.getClassLoader()));
        Collection modules = Initialization.getFromExtensions((ExtensionsConfig)new ExtensionsConfig(), DruidModule.class);
        HashSet<String> loadedModuleNames = new HashSet<String>();
        for (DruidModule module : modules) {
            Assert.assertFalse((String)"Duplicate extensions are loaded", (boolean)loadedModuleNames.contains(module.getClass().getName()));
            loadedModuleNames.add(module.getClass().getName());
        }
        Initialization.getLoadersMap().clear();
    }

    @Test
    public void test05MakeInjectorWithModules() {
        Injector startupInjector = GuiceInjectors.makeStartupInjector();
        Injector injector = Initialization.makeInjectorWithModules((Injector)startupInjector, (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("test-inject", null, false, null, null, true, false));
            }
        }));
        Assert.assertNotNull((Object)injector);
    }

    @Test
    public void test06GetClassLoaderForExtension() throws IOException {
        File some_extension_dir = this.temporaryFolder.newFolder();
        File a_jar = new File(some_extension_dir, "a.jar");
        File b_jar = new File(some_extension_dir, "b.jar");
        File c_jar = new File(some_extension_dir, "c.jar");
        a_jar.createNewFile();
        b_jar.createNewFile();
        c_jar.createNewFile();
        URLClassLoader loader = Initialization.getClassLoaderForExtension((File)some_extension_dir, (boolean)false);
        Object[] expectedURLs = new URL[]{a_jar.toURI().toURL(), b_jar.toURI().toURL(), c_jar.toURI().toURL()};
        Object[] actualURLs = loader.getURLs();
        Arrays.sort(actualURLs, Comparator.comparing(URL::getPath));
        Assert.assertArrayEquals((Object[])expectedURLs, (Object[])actualURLs);
    }

    @Test
    public void testGetLoadedModules() {
        Collection modules = Initialization.getLoadedImplementations(DruidModule.class);
        HashSet moduleSet = new HashSet(modules);
        Collection loadedModules = Initialization.getLoadedImplementations(DruidModule.class);
        Assert.assertEquals((String)"Set from loaded modules #1 should be same!", (long)modules.size(), (long)loadedModules.size());
        Assert.assertEquals((String)"Set from loaded modules #1 should be same!", moduleSet, new HashSet(loadedModules));
        Collection loadedModules2 = Initialization.getLoadedImplementations(DruidModule.class);
        Assert.assertEquals((String)"Set from loaded modules #2 should be same!", (long)modules.size(), (long)loadedModules2.size());
        Assert.assertEquals((String)"Set from loaded modules #2 should be same!", moduleSet, new HashSet(loadedModules2));
    }

    @Test
    public void testGetExtensionFilesToLoad_non_exist_extensions_dir() throws IOException {
        final File tmpDir = this.temporaryFolder.newFolder();
        Assert.assertTrue((String)"could not create missing folder", (!tmpDir.exists() || tmpDir.delete() ? 1 : 0) != 0);
        Assert.assertArrayEquals((String)"Non-exist root extensionsDir should return an empty array of File", (Object[])new File[0], (Object[])Initialization.getExtensionFilesToLoad((ExtensionsConfig)new ExtensionsConfig(){

            public String getDirectory() {
                return tmpDir.getAbsolutePath();
            }
        }));
    }

    @Test(expected=ISE.class)
    public void testGetExtensionFilesToLoad_wrong_type_extensions_dir() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFile();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        Initialization.getExtensionFilesToLoad((ExtensionsConfig)config);
    }

    @Test
    public void testGetExtensionFilesToLoad_empty_extensions_dir() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        Assert.assertArrayEquals((String)"Empty root extensionsDir should return an empty array of File", (Object[])new File[0], (Object[])Initialization.getExtensionFilesToLoad((ExtensionsConfig)config));
    }

    @Test
    public void testGetExtensionFilesToLoad_null_load_list() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        File mysql_metadata_storage = new File(extensionsDir, "mysql-metadata-storage");
        mysql_metadata_storage.mkdir();
        Object[] expectedFileList = new File[]{mysql_metadata_storage};
        Object[] actualFileList = Initialization.getExtensionFilesToLoad((ExtensionsConfig)config);
        Arrays.sort(actualFileList);
        Assert.assertArrayEquals((Object[])expectedFileList, (Object[])actualFileList);
    }

    @Test
    public void testGetExtensionFilesToLoad_with_load_list() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFolder();
        final File absolutePathExtension = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public LinkedHashSet<String> getLoadList() {
                return Sets.newLinkedHashSet(Arrays.asList("mysql-metadata-storage", absolutePathExtension.getAbsolutePath()));
            }

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        File mysql_metadata_storage = new File(extensionsDir, "mysql-metadata-storage");
        File random_extension = new File(extensionsDir, "random-extensions");
        mysql_metadata_storage.mkdir();
        random_extension.mkdir();
        Object[] expectedFileList = new File[]{mysql_metadata_storage, absolutePathExtension};
        Object[] actualFileList = Initialization.getExtensionFilesToLoad((ExtensionsConfig)config);
        Assert.assertArrayEquals((Object[])expectedFileList, (Object[])actualFileList);
    }

    @Test(expected=ISE.class)
    public void testGetExtensionFilesToLoad_with_non_exist_item_in_load_list() throws IOException {
        final File extensionsDir = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public LinkedHashSet<String> getLoadList() {
                return Sets.newLinkedHashSet((Iterable)ImmutableList.of((Object)"mysql-metadata-storage"));
            }

            public String getDirectory() {
                return extensionsDir.getAbsolutePath();
            }
        };
        File random_extension = new File(extensionsDir, "random-extensions");
        random_extension.mkdir();
        Initialization.getExtensionFilesToLoad((ExtensionsConfig)config);
    }

    @Test(expected=ISE.class)
    public void testGetHadoopDependencyFilesToLoad_wrong_type_root_hadoop_depenencies_dir() throws IOException {
        final File rootHadoopDependenciesDir = this.temporaryFolder.newFile();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getHadoopDependenciesDir() {
                return rootHadoopDependenciesDir.getAbsolutePath();
            }
        };
        Initialization.getHadoopDependencyFilesToLoad((List)ImmutableList.of(), (ExtensionsConfig)config);
    }

    @Test(expected=ISE.class)
    public void testGetHadoopDependencyFilesToLoad_non_exist_version_dir() throws IOException {
        final File rootHadoopDependenciesDir = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getHadoopDependenciesDir() {
                return rootHadoopDependenciesDir.getAbsolutePath();
            }
        };
        File hadoopClient = new File(rootHadoopDependenciesDir, "hadoop-client");
        hadoopClient.mkdir();
        Initialization.getHadoopDependencyFilesToLoad((List)ImmutableList.of((Object)"org.apache.hadoop:hadoop-client:2.3.0"), (ExtensionsConfig)config);
    }

    @Test
    public void testGetHadoopDependencyFilesToLoad_with_hadoop_coordinates() throws IOException {
        final File rootHadoopDependenciesDir = this.temporaryFolder.newFolder();
        ExtensionsConfig config = new ExtensionsConfig(){

            public String getHadoopDependenciesDir() {
                return rootHadoopDependenciesDir.getAbsolutePath();
            }
        };
        File hadoopClient = new File(rootHadoopDependenciesDir, "hadoop-client");
        File versionDir = new File(hadoopClient, "2.3.0");
        hadoopClient.mkdir();
        versionDir.mkdir();
        Object[] expectedFileList = new File[]{versionDir};
        Object[] actualFileList = Initialization.getHadoopDependencyFilesToLoad((List)ImmutableList.of((Object)"org.apache.hadoop:hadoop-client:2.3.0"), (ExtensionsConfig)config);
        Assert.assertArrayEquals((Object[])expectedFileList, (Object[])actualFileList);
    }

    @Test
    public void testGetURLsForClasspath() throws Exception {
        File tmpDir1 = this.temporaryFolder.newFolder();
        File tmpDir2 = this.temporaryFolder.newFolder();
        File tmpDir3 = this.temporaryFolder.newFolder();
        File tmpDir1a = new File(tmpDir1, "a.jar");
        tmpDir1a.createNewFile();
        File tmpDir1b = new File(tmpDir1, "b.jar");
        tmpDir1b.createNewFile();
        new File(tmpDir1, "note1.txt").createNewFile();
        File tmpDir2c = new File(tmpDir2, "c.jar");
        tmpDir2c.createNewFile();
        File tmpDir2d = new File(tmpDir2, "d.jar");
        tmpDir2d.createNewFile();
        File tmpDir2e = new File(tmpDir2, "e.JAR");
        tmpDir2e.createNewFile();
        new File(tmpDir2, "note2.txt").createNewFile();
        String cp = tmpDir1.getAbsolutePath() + File.separator + "*" + File.pathSeparator + tmpDir3.getAbsolutePath() + File.pathSeparator + tmpDir2.getAbsolutePath() + File.separator + "*";
        List urLsForClasspath = Initialization.getURLsForClasspath((String)cp);
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new URL[]{tmpDir1a.toURI().toURL(), tmpDir1b.toURI().toURL()}), (Object)Sets.newHashSet(urLsForClasspath.subList(0, 2)));
        Assert.assertEquals((Object)tmpDir3.toURI().toURL(), urLsForClasspath.get(2));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new URL[]{tmpDir2c.toURI().toURL(), tmpDir2d.toURI().toURL(), tmpDir2e.toURI().toURL()}), (Object)Sets.newHashSet(urLsForClasspath.subList(3, 6)));
    }

    @Test
    public void testExtensionsWithSameDirName() throws Exception {
        String extensionName = "some_extension";
        File tmpDir1 = this.temporaryFolder.newFolder();
        File tmpDir2 = this.temporaryFolder.newFolder();
        File extension1 = new File(tmpDir1, "some_extension");
        File extension2 = new File(tmpDir2, "some_extension");
        Assert.assertTrue((boolean)extension1.mkdir());
        Assert.assertTrue((boolean)extension2.mkdir());
        File jar1 = new File(extension1, "jar1.jar");
        File jar2 = new File(extension2, "jar2.jar");
        Assert.assertTrue((boolean)jar1.createNewFile());
        Assert.assertTrue((boolean)jar2.createNewFile());
        URLClassLoader classLoader1 = Initialization.getClassLoaderForExtension((File)extension1, (boolean)false);
        URLClassLoader classLoader2 = Initialization.getClassLoaderForExtension((File)extension2, (boolean)false);
        Assert.assertArrayEquals((Object[])new URL[]{jar1.toURI().toURL()}, (Object[])classLoader1.getURLs());
        Assert.assertArrayEquals((Object[])new URL[]{jar2.toURI().toURL()}, (Object[])classLoader2.getURLs());
    }

    public static class TestDruidModule
    implements DruidModule {
        public List<? extends org.apache.hive.druid.com.fasterxml.jackson.databind.Module> getJacksonModules() {
            return ImmutableList.of();
        }

        public void configure(Binder binder) {
        }
    }
}

