/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.indexing.overlord.supervisor;

import java.io.IOException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.indexing.overlord.supervisor.SupervisorStatus;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.junit.Assert;
import org.junit.Test;

public class SupervisorStatusTest {
    @Test
    public void testSerde() throws IOException {
        DefaultObjectMapper mapper = new DefaultObjectMapper();
        SupervisorStatus.Builder builder = new SupervisorStatus.Builder();
        SupervisorStatus supervisorStatus = builder.withId("wikipedia").withState("RUNNING").withDetailedState("RUNNING").withHealthy(true).withType("kafka").withSource("wikipedia").withSuspended(false).build();
        String serialized = mapper.writeValueAsString((Object)supervisorStatus);
        SupervisorStatus deserialized = (SupervisorStatus)mapper.readValue(serialized, SupervisorStatus.class);
        Assert.assertEquals((Object)supervisorStatus, (Object)deserialized);
    }

    @Test
    public void testJsonAttr() throws IOException {
        String json = "{\"id\":\"wikipedia\",\"state\":\"UNHEALTHY_SUPERVISOR\",\"detailedState\":\"UNHEALTHY_SUPERVISOR\",\"healthy\":false,\"type\":\"kafka\",\"source\":\"wikipedia\",\"suspended\":false}";
        ObjectMapper mapper = new ObjectMapper();
        SupervisorStatus deserialized = (SupervisorStatus)mapper.readValue(json, SupervisorStatus.class);
        Assert.assertNotNull((Object)deserialized);
        Assert.assertEquals((Object)"wikipedia", (Object)deserialized.getId());
        String serialized = mapper.writeValueAsString((Object)deserialized);
        Assert.assertTrue((boolean)serialized.contains("\"source\""));
        Assert.assertEquals((Object)json, (Object)serialized);
    }
}

