/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.indexer;

import java.io.IOException;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonParser;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonToken;
import org.apache.hive.druid.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.Module;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.hive.druid.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.apache.hive.druid.org.apache.druid.indexer.RunnerTaskState;
import org.apache.hive.druid.org.apache.druid.indexer.TaskLocation;
import org.apache.hive.druid.org.apache.druid.indexer.TaskState;
import org.apache.hive.druid.org.apache.druid.indexer.TaskStatusPlus;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class TaskStatusPlusTest {
    @Test
    public void testSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new SimpleModule().addDeserializer(DateTime.class, (JsonDeserializer)new DateTimeDeserializer()).addSerializer(DateTime.class, (JsonSerializer)ToStringSerializer.instance));
        TaskStatusPlus status = new TaskStatusPlus("testId", "testGroupId", "testType", DateTimes.nowUtc(), DateTimes.nowUtc(), TaskState.RUNNING, RunnerTaskState.RUNNING, Long.valueOf(1000L), TaskLocation.create((String)"testHost", (int)1010, (int)-1), "ds_test", null);
        String json = mapper.writeValueAsString((Object)status);
        Assert.assertEquals((Object)status, (Object)mapper.readValue(json, TaskStatusPlus.class));
    }

    @Test
    public void testJsonAttributes() throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new SimpleModule().addDeserializer(DateTime.class, (JsonDeserializer)new DateTimeDeserializer()).addSerializer(DateTime.class, (JsonSerializer)ToStringSerializer.instance));
        String json = "{\n\"id\": \"testId\",\n\"groupId\": \"testGroupId\",\n\"type\": \"testType\",\n\"createdTime\": \"2018-09-17T06:35:17.392Z\",\n\"queueInsertionTime\": \"2018-09-17T06:35:17.392Z\",\n\"statusCode\": \"RUNNING\",\n\"status\": \"RUNNING\",\n\"runnerStatusCode\": \"RUNNING\",\n\"duration\": 1000,\n\"location\": {\n\"host\": \"testHost\",\n\"port\": 1010,\n\"tlsPort\": -1\n},\n\"dataSource\": \"ds_test\",\n\"errorMsg\": null\n}";
        TaskStatusPlus taskStatusPlus = (TaskStatusPlus)mapper.readValue("{\n\"id\": \"testId\",\n\"groupId\": \"testGroupId\",\n\"type\": \"testType\",\n\"createdTime\": \"2018-09-17T06:35:17.392Z\",\n\"queueInsertionTime\": \"2018-09-17T06:35:17.392Z\",\n\"statusCode\": \"RUNNING\",\n\"status\": \"RUNNING\",\n\"runnerStatusCode\": \"RUNNING\",\n\"duration\": 1000,\n\"location\": {\n\"host\": \"testHost\",\n\"port\": 1010,\n\"tlsPort\": -1\n},\n\"dataSource\": \"ds_test\",\n\"errorMsg\": null\n}", TaskStatusPlus.class);
        Assert.assertNotNull((Object)taskStatusPlus);
        Assert.assertNotNull((Object)taskStatusPlus.getStatusCode());
        Assert.assertTrue((boolean)taskStatusPlus.getStatusCode().isRunnable());
        Assert.assertNotNull((Object)taskStatusPlus.getRunnerStatusCode());
        String serialized = mapper.writeValueAsString((Object)taskStatusPlus);
        Assert.assertTrue((boolean)serialized.contains("\"status\":"));
        Assert.assertTrue((boolean)serialized.contains("\"statusCode\":"));
        Assert.assertTrue((boolean)serialized.contains("\"runnerStatusCode\":"));
    }

    private static class DateTimeDeserializer
    extends StdDeserializer<DateTime> {
        public DateTimeDeserializer() {
            super(DateTime.class);
        }

        public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NUMBER_INT) {
                return DateTimes.utc((long)jp.getLongValue());
            }
            if (t == JsonToken.VALUE_STRING) {
                String str = jp.getText().trim();
                if (str.length() == 0) {
                    return null;
                }
                return DateTimes.ISO_DATE_OR_TIME_WITH_OFFSET.parse(str);
            }
            throw ctxt.mappingException(this.getValueClass());
        }
    }
}

