/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.indexer;

import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.indexer.Checks;
import org.apache.hive.druid.org.apache.druid.indexer.Property;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ChecksTest {
    private static final String NAME1 = "name1";
    private static final Integer VALUE1 = 1;
    private static final String NAME2 = "name2";
    private static final Integer VALUE2 = 2;
    private static final Integer NULL = null;
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void checkAtMostOneNotNullFirstNull() {
        Property result = Checks.checkAtMostOneNotNull((String)NAME1, (Object)NULL, (String)NAME2, (Object)VALUE2);
        Assert.assertEquals((Object)NAME2, (Object)result.getName());
        Assert.assertEquals((Object)VALUE2, (Object)result.getValue());
    }

    @Test
    public void checkAtMostOneNotNullSecondNull() {
        Property result = Checks.checkAtMostOneNotNull((String)NAME1, (Object)VALUE1, (String)NAME2, (Object)NULL);
        Assert.assertEquals((Object)NAME1, (Object)result.getName());
        Assert.assertEquals((Object)VALUE1, (Object)result.getValue());
    }

    @Test
    public void checkAtMostOneNotNullBothNull() {
        Property result = Checks.checkAtMostOneNotNull((String)NAME1, (Object)NULL, (String)NAME2, (Object)NULL);
        Assert.assertEquals((Object)NAME1, (Object)result.getName());
        Assert.assertEquals((Object)NULL, (Object)result.getValue());
    }

    @Test
    public void checkAtMostOneNotNullNeitherNull() {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage(StringUtils.format((String)"[Property{name='%s', value=%s}] or [Property{name='%s', value=%s}]", (Object[])new Object[]{NAME1, VALUE1, NAME2, VALUE2}));
        Checks.checkAtMostOneNotNull((String)NAME1, (Object)VALUE1, (String)NAME2, (Object)VALUE2);
    }

    @Test
    public void testCheckOneNotNullOrEmpty() {
        ImmutableList properties = ImmutableList.of((Object)new Property("p1", null), (Object)new Property("p2", (Object)2), (Object)new Property("p3", null), (Object)new Property("p4", Collections.emptyList()));
        Property property = Checks.checkOneNotNullOrEmpty((List)properties);
        Assert.assertEquals((Object)new Property("p2", (Object)2), (Object)property);
    }

    @Test
    public void testCheckOneNotNullOrEmptyWithTwoNonNulls() {
        ImmutableList properties = ImmutableList.of((Object)new Property("p1", null), (Object)new Property("p2", (Object)2), (Object)new Property("p3", (Object)3), (Object)new Property("p4", Collections.emptyList()));
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("At most one of [Property{name='p1', value=null}, Property{name='p2', value=2}, Property{name='p3', value=3}, Property{name='p4', value=[]}] must be present");
        Checks.checkOneNotNullOrEmpty((List)properties);
    }

    @Test
    public void testCheckOneNotNullOrEmptyWithNonNullAndNonEmpty() {
        ImmutableList properties = ImmutableList.of((Object)new Property("p1", null), (Object)new Property("p2", (Object)2), (Object)new Property("p3", null), (Object)new Property("p4", (Object)Lists.newArrayList((Object[])new Integer[]{1, 2})));
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("At most one of [Property{name='p1', value=null}, Property{name='p2', value=2}, Property{name='p3', value=null}, Property{name='p4', value=[1, 2]}] must be present");
        Checks.checkOneNotNullOrEmpty((List)properties);
    }

    @Test
    public void testCheckOneNotNullOrEmptyWithAllNulls() {
        ImmutableList properties = ImmutableList.of((Object)new Property("p1", null), (Object)new Property("p2", null), (Object)new Property("p3", null), (Object)new Property("p4", null));
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("At least one of [Property{name='p1', value=null}, Property{name='p2', value=null}, Property{name='p3', value=null}, Property{name='p4', value=null}] must be present");
        Checks.checkOneNotNullOrEmpty((List)properties);
    }
}

