/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.hll;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.java.util.common.UnsafeUtils;

class ByteBuffers {
    private static final long ADDRESS_OFFSET;
    private static final MethodHandle GET_LONG;

    ByteBuffers() {
    }

    private static long lookupAddressOffset(MethodHandles.Lookup lookup) throws Throwable {
        MethodHandle objectFieldOffset = lookup.findVirtual(UnsafeUtils.theUnsafeClass(), "objectFieldOffset", MethodType.methodType(Long.TYPE, Field.class));
        return objectFieldOffset.bindTo(UnsafeUtils.theUnsafe()).invoke(Buffer.class.getDeclaredField("address"));
    }

    private static MethodHandle lookupGetLong(MethodHandles.Lookup lookup) throws Throwable {
        MethodHandle getLong = lookup.findVirtual(UnsafeUtils.theUnsafeClass(), "getLong", MethodType.methodType(Long.TYPE, Object.class, Long.TYPE));
        return getLong.bindTo(UnsafeUtils.theUnsafe());
    }

    public static long getAddress(ByteBuffer buf) {
        try {
            return GET_LONG.invoke(buf, ADDRESS_OFFSET);
        }
        catch (Throwable t) {
            throw new UnsupportedOperationException("Unsafe.getLong is unsupported", t);
        }
    }

    public static ByteBuffer allocateAlignedByteBuffer(int capacity, int align) {
        Preconditions.checkArgument((Long.bitCount(align) == 1 ? 1 : 0) != 0, (Object)"Alignment must be a power of 2");
        ByteBuffer buf = ByteBuffer.allocateDirect(capacity + align);
        long address = ByteBuffers.getAddress(buf);
        if ((address & (long)(align - 1)) == 0L) {
            buf.limit(capacity);
        } else {
            int offset = (int)((long)align - (address & (long)(align - 1)));
            buf.position(offset);
            buf.limit(offset + capacity);
        }
        return buf.slice();
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            ADDRESS_OFFSET = ByteBuffers.lookupAddressOffset(lookup);
            GET_LONG = ByteBuffers.lookupGetLong(lookup);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to lookup Unsafe methods", t);
        }
    }
}

