/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Properties;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.guice.ConfigModule;
import org.apache.hive.druid.org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.PropertiesModule;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.query.metadata.SegmentMetadataQueryConfig;
import org.apache.hive.druid.org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.junit.Assert;
import org.junit.Test;

public class SegmentMetadataQueryConfigTest {
    @Test
    public void testSerdeSegmentMetadataQueryConfig() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.install((Module)new PropertiesModule(Collections.singletonList("test.runtime.properties")));
                binder.install((Module)new ConfigModule());
                binder.install((Module)new DruidGuiceExtensions());
                JsonConfigProvider.bind((Binder)binder, (String)"druid.query.segmentMetadata", SegmentMetadataQueryConfig.class);
            }

            @Provides
            @LazySingleton
            public ObjectMapper jsonMapper() {
                return new DefaultObjectMapper();
            }
        }});
        Properties props = (Properties)injector.getInstance(Properties.class);
        SegmentMetadataQueryConfig config = (SegmentMetadataQueryConfig)injector.getInstance(SegmentMetadataQueryConfig.class);
        EnumSet expectedDefaultAnalysis = config.getDefaultAnalysisTypes();
        String actualDefaultAnalysis = props.getProperty("druid.query.segmentMetadata.defaultAnalysisTypes");
        Iterator it = expectedDefaultAnalysis.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (it.hasNext()) {
            SegmentMetadataQuery.AnalysisType e = (SegmentMetadataQuery.AnalysisType)it.next();
            sb.append("\"" + e + "\"");
            if (!it.hasNext()) continue;
            sb.append(',').append(' ');
        }
        sb.append(']');
        String expectedDefaultAnalysisAsString = sb.toString();
        Assert.assertEquals((Object)expectedDefaultAnalysisAsString, (Object)actualDefaultAnalysis);
        Assert.assertEquals((Object)props.getProperty("druid.query.segmentMetadata.defaultHistory"), (Object)config.getDefaultHistory().toString());
    }
}

