/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.guice.PolyBind;
import org.junit.Assert;
import org.junit.Test;

public class PolyBindTest {
    private Properties props;
    private Injector injector;

    public void setUp(Module ... modules) {
        this.props = new Properties();
        this.injector = Guice.createInjector((Iterable)Iterables.concat(Collections.singletonList(new Module(){

            public void configure(Binder binder) {
                binder.bind(Properties.class).toInstance((Object)PolyBindTest.this.props);
                PolyBind.createChoice((Binder)binder, (String)"billy", (Key)Key.get(Gogo.class), (Key)Key.get(GoA.class));
                PolyBind.createChoiceWithDefault((Binder)binder, (String)"sally", (Key)Key.get(GogoSally.class), (String)"b");
            }
        }), Arrays.asList(modules)));
    }

    @Test
    public void testSanity() {
        this.setUp(new Module(){

            public void configure(Binder binder) {
                MapBinder gogoBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(Gogo.class));
                gogoBinder.addBinding((Object)"a").to(GoA.class);
                gogoBinder.addBinding((Object)"b").to(GoB.class);
                MapBinder gogoSallyBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(GogoSally.class));
                gogoSallyBinder.addBinding((Object)"a").to(GoA.class);
                gogoSallyBinder.addBinding((Object)"b").to(GoB.class);
                PolyBind.createChoice((Binder)binder, (String)"billy", (Key)Key.get(Gogo.class, (Annotation)Names.named((String)"reverse")), (Key)Key.get(GoB.class));
                MapBinder annotatedGogoBinder = PolyBind.optionBinder((Binder)binder, (Key)Key.get(Gogo.class, (Annotation)Names.named((String)"reverse")));
                annotatedGogoBinder.addBinding((Object)"a").to(GoB.class);
                annotatedGogoBinder.addBinding((Object)"b").to(GoA.class);
            }
        });
        Assert.assertEquals((Object)"A", (Object)((Gogo)this.injector.getInstance(Gogo.class)).go());
        Assert.assertEquals((Object)"B", (Object)((Gogo)this.injector.getInstance(Key.get(Gogo.class, (Annotation)Names.named((String)"reverse")))).go());
        this.props.setProperty("billy", "b");
        Assert.assertEquals((Object)"B", (Object)((Gogo)this.injector.getInstance(Gogo.class)).go());
        Assert.assertEquals((Object)"A", (Object)((Gogo)this.injector.getInstance(Key.get(Gogo.class, (Annotation)Names.named((String)"reverse")))).go());
        this.props.setProperty("billy", "a");
        Assert.assertEquals((Object)"A", (Object)((Gogo)this.injector.getInstance(Gogo.class)).go());
        Assert.assertEquals((Object)"B", (Object)((Gogo)this.injector.getInstance(Key.get(Gogo.class, (Annotation)Names.named((String)"reverse")))).go());
        this.props.setProperty("billy", "b");
        Assert.assertEquals((Object)"B", (Object)((Gogo)this.injector.getInstance(Gogo.class)).go());
        Assert.assertEquals((Object)"A", (Object)((Gogo)this.injector.getInstance(Key.get(Gogo.class, (Annotation)Names.named((String)"reverse")))).go());
        this.props.setProperty("billy", "c");
        try {
            Assert.assertEquals((Object)"A", (Object)((Gogo)this.injector.getInstance(Gogo.class)).go());
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof ProvisionException));
            Assert.assertTrue((boolean)e.getMessage().contains("Unknown provider[c] of Key[type=org.apache.druid.guice.PolyBindTest$Gogo"));
        }
        try {
            Assert.assertEquals((Object)"B", (Object)((Gogo)this.injector.getInstance(Key.get(Gogo.class, (Annotation)Names.named((String)"reverse")))).go());
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof ProvisionException));
            Assert.assertTrue((boolean)e.getMessage().contains("Unknown provider[c] of Key[type=org.apache.druid.guice.PolyBindTest$Gogo"));
        }
        Assert.assertEquals((Object)"B", (Object)((GogoSally)this.injector.getInstance(GogoSally.class)).go());
        this.props.setProperty("sally", "a");
        Assert.assertEquals((Object)"A", (Object)((GogoSally)this.injector.getInstance(GogoSally.class)).go());
        this.props.setProperty("sally", "b");
        Assert.assertEquals((Object)"B", (Object)((GogoSally)this.injector.getInstance(GogoSally.class)).go());
        this.props.setProperty("sally", "c");
        try {
            ((GogoSally)this.injector.getInstance(GogoSally.class)).go();
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof ProvisionException));
            Assert.assertTrue((boolean)e.getMessage().contains("Unknown provider[c] of Key[type=org.apache.druid.guice.PolyBindTest$GogoSally"));
        }
    }

    public static class GoB
    implements Gogo,
    GogoSally {
        @Override
        public String go() {
            return "B";
        }
    }

    public static class GoA
    implements Gogo,
    GogoSally {
        @Override
        public String go() {
            return "A";
        }
    }

    public static interface GogoSally {
        public String go();
    }

    public static interface Gogo {
        public String go();
    }
}

