/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.Collections;
import java.util.Properties;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.guice.ConfigModule;
import org.apache.hive.druid.org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigProvider;
import org.apache.hive.druid.org.apache.druid.guice.LazySingleton;
import org.apache.hive.druid.org.apache.druid.guice.PropertiesModule;
import org.apache.hive.druid.org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.hive.druid.org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.junit.Assert;
import org.junit.Test;

public class MetadataStorageTablesConfigTest {
    @Test
    public void testSerdeMetadataStorageTablesConfig() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new Module(){

            public void configure(Binder binder) {
                binder.install((Module)new PropertiesModule(Collections.singletonList("test.runtime.properties")));
                binder.install((Module)new ConfigModule());
                binder.install((Module)new DruidGuiceExtensions());
                JsonConfigProvider.bind((Binder)binder, (String)"druid.metadata.storage.tables", MetadataStorageTablesConfig.class);
            }

            @Provides
            @LazySingleton
            public ObjectMapper jsonMapper() {
                return new DefaultObjectMapper();
            }
        }});
        Properties props = (Properties)injector.getInstance(Properties.class);
        MetadataStorageTablesConfig config = (MetadataStorageTablesConfig)injector.getInstance(MetadataStorageTablesConfig.class);
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.base"), (Object)config.getBase());
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.segments"), (Object)config.getSegmentsTable());
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.rules"), (Object)config.getRulesTable());
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.config"), (Object)config.getConfigTable());
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.tasks"), (Object)config.getEntryTable("task"));
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.taskLog"), (Object)config.getLogTable("task"));
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.taskLock"), (Object)config.getLockTable("task"));
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.dataSource"), (Object)config.getDataSourceTable());
        Assert.assertEquals((Object)props.getProperty("druid.metadata.storage.tables.supervisors"), (Object)config.getSupervisorTable());
    }
}

