/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.apache.hive.druid.org.apache.druid.guice.DruidGuiceExtensions;
import org.apache.hive.druid.org.apache.druid.guice.LifecycleModule;
import org.apache.hive.druid.org.apache.druid.guice.ManageLifecycle;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.hive.druid.org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.junit.Assert;
import org.junit.Test;

public class LifecycleScopeTest {
    @Test
    public void testAnnotation() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new DruidGuiceExtensions(), new LifecycleModule(), new Module(){

            public void configure(Binder binder) {
                binder.bind(TestInterface.class).to(AnnotatedClass.class);
            }
        }});
        Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
        TestInterface instance = (TestInterface)injector.getInstance(TestInterface.class);
        this.testIt(injector, lifecycle, instance);
    }

    @Test
    public void testExplicit() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new DruidGuiceExtensions(), new LifecycleModule(), new Module(){

            public void configure(Binder binder) {
                binder.bind(TestInterface.class).to(ExplicitClass.class).in(ManageLifecycle.class);
            }
        }});
        Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
        TestInterface instance = (TestInterface)injector.getInstance(TestInterface.class);
        this.testIt(injector, lifecycle, instance);
    }

    private void testIt(Injector injector, Lifecycle lifecycle, TestInterface instance) throws Exception {
        Assert.assertEquals((long)0L, (long)instance.getStarted());
        Assert.assertEquals((long)0L, (long)instance.getStopped());
        Assert.assertEquals((long)0L, (long)instance.getRan());
        instance.run();
        Assert.assertEquals((long)0L, (long)instance.getStarted());
        Assert.assertEquals((long)0L, (long)instance.getStopped());
        Assert.assertEquals((long)1L, (long)instance.getRan());
        lifecycle.start();
        Assert.assertEquals((long)1L, (long)instance.getStarted());
        Assert.assertEquals((long)0L, (long)instance.getStopped());
        Assert.assertEquals((long)1L, (long)instance.getRan());
        ((TestInterface)injector.getInstance(TestInterface.class)).run();
        Assert.assertEquals((long)1L, (long)instance.getStarted());
        Assert.assertEquals((long)0L, (long)instance.getStopped());
        Assert.assertEquals((long)2L, (long)instance.getRan());
        lifecycle.stop();
        Assert.assertEquals((long)1L, (long)instance.getStarted());
        Assert.assertEquals((long)1L, (long)instance.getStopped());
        Assert.assertEquals((long)2L, (long)instance.getRan());
    }

    @Test
    public void testAnnotatedAndExplicit() throws Exception {
        Injector injector = Guice.createInjector((Module[])new Module[]{new DruidGuiceExtensions(), new LifecycleModule(), new Module(){

            public void configure(Binder binder) {
                binder.bind(TestInterface.class).to(AnnotatedClass.class).in(ManageLifecycle.class);
            }
        }});
        Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
        TestInterface instance = (TestInterface)injector.getInstance(TestInterface.class);
        Assert.assertEquals((long)0L, (long)instance.getStarted());
        Assert.assertEquals((long)0L, (long)instance.getStopped());
        Assert.assertEquals((long)0L, (long)instance.getRan());
        instance.run();
        Assert.assertEquals((long)0L, (long)instance.getStarted());
        Assert.assertEquals((long)0L, (long)instance.getStopped());
        Assert.assertEquals((long)1L, (long)instance.getRan());
        lifecycle.start();
        Assert.assertEquals((long)2L, (long)instance.getStarted());
        Assert.assertEquals((long)0L, (long)instance.getStopped());
        Assert.assertEquals((long)1L, (long)instance.getRan());
        ((TestInterface)injector.getInstance(TestInterface.class)).run();
        Assert.assertEquals((long)2L, (long)instance.getStarted());
        Assert.assertEquals((long)0L, (long)instance.getStopped());
        Assert.assertEquals((long)2L, (long)instance.getRan());
        lifecycle.stop();
        Assert.assertEquals((long)2L, (long)instance.getStarted());
        Assert.assertEquals((long)2L, (long)instance.getStopped());
        Assert.assertEquals((long)2L, (long)instance.getRan());
    }

    public static class ExplicitClass
    implements TestInterface {
        int started = 0;
        int stopped = 0;
        int ran = 0;

        @LifecycleStart
        public void start() {
            ++this.started;
        }

        @LifecycleStop
        public void stop() {
            ++this.stopped;
        }

        @Override
        public void run() {
            ++this.ran;
        }

        @Override
        public int getStarted() {
            return this.started;
        }

        @Override
        public int getStopped() {
            return this.stopped;
        }

        @Override
        public int getRan() {
            return this.ran;
        }
    }

    @ManageLifecycle
    public static class AnnotatedClass
    implements TestInterface {
        int started = 0;
        int stopped = 0;
        int ran = 0;

        @LifecycleStart
        public void start() {
            ++this.started;
        }

        @LifecycleStop
        public void stop() {
            ++this.stopped;
        }

        @Override
        public void run() {
            ++this.ran;
        }

        @Override
        public int getStarted() {
            return this.started;
        }

        @Override
        public int getStopped() {
            return this.stopped;
        }

        @Override
        public int getRan() {
            return this.ran;
        }
    }

    private static interface TestInterface {
        public void run();

        public int getStarted();

        public int getStopped();

        public int getRan();
    }
}

