/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.guice;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.validation.executable.ExecutableValidator;
import javax.validation.metadata.BeanDescriptor;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableSet;
import org.apache.hive.druid.org.apache.druid.TestObjectMapper;
import org.apache.hive.druid.org.apache.druid.guice.JsonConfigurator;
import org.apache.hive.druid.org.apache.druid.guice.MappableObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonConfiguratorTest {
    private static final String PROP_PREFIX = "test.property.prefix.";
    private final ObjectMapper mapper = new TestObjectMapper();
    private final Properties properties = new Properties();
    final Validator validator = new Validator(){

        public <T> Set<ConstraintViolation<T>> validate(T object, Class<?> ... groups) {
            return ImmutableSet.of();
        }

        public <T> Set<ConstraintViolation<T>> validateProperty(T object, String propertyName, Class<?> ... groups) {
            return ImmutableSet.of();
        }

        public <T> Set<ConstraintViolation<T>> validateValue(Class<T> beanType, String propertyName, Object value, Class<?> ... groups) {
            return ImmutableSet.of();
        }

        public BeanDescriptor getConstraintsForClass(Class<?> clazz) {
            return null;
        }

        public <T> T unwrap(Class<T> type) {
            return null;
        }

        public ExecutableValidator forExecutables() {
            return null;
        }
    };

    @Before
    public void setUp() {
        this.mapper.registerSubtypes(new Class[]{MappableObject.class});
    }

    @Test
    public void testTest() {
        Assert.assertEquals((Object)new MappableObject("p1", (List<String>)ImmutableList.of((Object)"p2"), "p2"), (Object)new MappableObject("p1", (List<String>)ImmutableList.of((Object)"p2"), "p2"));
        Assert.assertEquals((Object)new MappableObject("p1", null, null), (Object)new MappableObject("p1", (List<String>)ImmutableList.of(), null));
    }

    @Test
    public void testsimpleConfigurate() {
        JsonConfigurator configurator = new JsonConfigurator(this.mapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop1", "prop1");
        this.properties.setProperty("test.property.prefix.prop1List", "[\"prop2\"]");
        MappableObject obj = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        Assert.assertEquals((Object)"prop1", (Object)obj.prop1);
        Assert.assertEquals((Object)ImmutableList.of((Object)"prop2"), obj.prop1List);
    }

    @Test
    public void testMissingConfigList() {
        JsonConfigurator configurator = new JsonConfigurator(this.mapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop1", "prop1");
        MappableObject obj = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        Assert.assertEquals((Object)"prop1", (Object)obj.prop1);
        Assert.assertEquals((Object)ImmutableList.of(), obj.prop1List);
    }

    @Test
    public void testMissingConfig() {
        JsonConfigurator configurator = new JsonConfigurator(this.mapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop1List", "[\"prop2\"]");
        MappableObject obj = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        Assert.assertNull((Object)obj.prop1);
        Assert.assertEquals((Object)ImmutableList.of((Object)"prop2"), obj.prop1List);
    }

    @Test
    public void testQuotedConfig() {
        JsonConfigurator configurator = new JsonConfigurator(this.mapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop1", "testing \"prop1\"");
        MappableObject obj = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        Assert.assertEquals((Object)"testing \"prop1\"", (Object)obj.prop1);
        Assert.assertEquals((Object)ImmutableList.of(), obj.prop1List);
    }

    @Test
    public void testPropertyWithDot() {
        JsonConfigurator configurator = new JsonConfigurator(this.mapper, this.validator);
        this.properties.setProperty("test.property.prefix.prop2.prop.2", "testing");
        this.properties.setProperty("test.property.prefix.prop1", "prop1");
        MappableObject obj = (MappableObject)configurator.configurate(this.properties, PROP_PREFIX, MappableObject.class);
        Assert.assertEquals((Object)"testing", (Object)obj.prop2);
        Assert.assertEquals((Object)ImmutableList.of(), obj.prop1List);
        Assert.assertEquals((Object)"prop1", (Object)obj.prop1);
    }
}

