/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.hive.druid.com.google.common.base.Preconditions;
import org.apache.hive.druid.org.apache.druid.data.input.impl.RetryingInputStream;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class RetryingInputStreamTest {
    private static final int MAX_RETRY = 5;
    private static final int MAX_ERROR = 4;
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private File testFile;
    private DataInputStream inputStream;
    private boolean throwError = true;
    private int errorCount = 0;

    @Before
    public void setup() throws IOException {
        this.testFile = this.temporaryFolder.newFile();
        try (FileOutputStream fis = new FileOutputStream(this.testFile);
             GZIPOutputStream gis = new GZIPOutputStream(fis);
             DataOutputStream dis = new DataOutputStream(gis);){
            for (int i = 0; i < 10000; ++i) {
                dis.writeInt(i);
            }
        }
        this.throwError = false;
        RetryingInputStream retryingInputStream = new RetryingInputStream((Object)this.testFile, (ObjectOpenFunction)new ObjectOpenFunction<File>(){

            public InputStream open(File object) throws IOException {
                return new TestInputStream(new FileInputStream(object));
            }

            public InputStream open(File object, long start) throws IOException {
                FileInputStream fis = new FileInputStream(object);
                Preconditions.checkState((fis.skip(start) == start ? 1 : 0) != 0);
                return new TestInputStream(fis);
            }
        }, e -> e instanceof IOException, 5);
        this.inputStream = new DataInputStream(new GZIPInputStream((InputStream)retryingInputStream));
        this.throwError = true;
    }

    @After
    public void teardown() throws IOException {
        this.inputStream.close();
        FileUtils.forceDelete((File)this.testFile);
    }

    @Test
    public void testReadRetry() throws IOException {
        for (int i = 0; i < 10000; ++i) {
            Assert.assertEquals((long)i, (long)this.inputStream.readInt());
        }
    }

    private class TestInputStream
    extends InputStream {
        private final InputStream delegate;

        TestInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (RetryingInputStreamTest.this.throwError) {
                RetryingInputStreamTest.this.throwError = false;
                RetryingInputStreamTest.this.errorCount++;
                if (RetryingInputStreamTest.this.errorCount % 2 == 0) {
                    throw new IOException("test retry");
                }
                this.delegate.close();
                throw new SocketException("Test Connection reset");
            }
            RetryingInputStreamTest.this.throwError = RetryingInputStreamTest.this.errorCount < 4;
            return this.delegate.read(b, off, len);
        }
    }
}

