/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonFactory;
import org.apache.hive.druid.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.hive.druid.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.fasterxml.jackson.dataformat.smile.SmileFactory;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.data.input.impl.prefetch.JsonIterator;
import org.junit.Assert;
import org.junit.Test;

public class JsonIteratorTest {
    @Test
    public void testSerde() throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new SmileFactory());
        ImmutableList expectedList = ImmutableList.of((Object)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)2));
        File testFile = File.createTempFile("testfile", "");
        TypeReference<Map<String, Object>> type = new TypeReference<Map<String, Object>>(){};
        try (FileOutputStream fos = new FileOutputStream(testFile);){
            JsonGenerator jg = mapper.getFactory().createGenerator((OutputStream)fos);
            jg.writeStartArray();
            for (Map mapFromList : expectedList) {
                jg.writeObject((Object)mapFromList);
            }
            jg.writeEndArray();
            jg.close();
        }
        JsonIterator testJsonIterator = new JsonIterator((TypeReference)type, (InputStream)new FileInputStream(testFile), () -> {}, mapper);
        ArrayList<Object> actualList = new ArrayList<Object>();
        while (testJsonIterator.hasNext()) {
            actualList.add(testJsonIterator.next());
        }
        testJsonIterator.close();
        Assert.assertEquals((Object)expectedList, actualList);
    }
}

