/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.hive.druid.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hive.druid.com.fasterxml.jackson.databind.MapperFeature;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Lists;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DelimitedParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.ParseException;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ParseSpecTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ObjectMapper mapper;

    @Before
    public void setUp() {
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.configure(MapperFeature.AUTO_DETECT_GETTERS, false);
        this.mapper.configure(MapperFeature.AUTO_DETECT_FIELDS, false);
        this.mapper.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false);
        this.mapper.configure(MapperFeature.AUTO_DETECT_SETTERS, false);
        this.mapper.configure(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS, false);
    }

    @Test(expected=ParseException.class)
    public void testDuplicateNames() {
        DelimitedParseSpec spec = new DelimitedParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("a", "b", "a")), new ArrayList(), new ArrayList()), ",", " ", Arrays.asList("a", "b"), false, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDimAndDimExcluOverlap() {
        DelimitedParseSpec spec = new DelimitedParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Arrays.asList("a", "B")), Collections.singletonList("B"), new ArrayList()), ",", null, Arrays.asList("a", "B"), false, 0);
    }

    @Test
    public void testDimExclusionDuplicate() {
        DelimitedParseSpec spec = new DelimitedParseSpec(new TimestampSpec("timestamp", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Collections.singletonList("a")), (List)Lists.newArrayList((Object[])new String[]{"B", "B"}), new ArrayList()), ",", null, Arrays.asList("a", "B"), false, 0);
    }

    @Test
    public void testDefaultTimestampSpec() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("parseSpec requires timestampSpec");
        DelimitedParseSpec spec = new DelimitedParseSpec(null, new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Collections.singletonList("a")), (List)Lists.newArrayList((Object[])new String[]{"B", "B"}), new ArrayList()), ",", null, Arrays.asList("a", "B"), false, 0);
    }

    @Test
    public void testDimensionSpecRequired() {
        this.expectedException.expect(NullPointerException.class);
        this.expectedException.expectMessage("parseSpec requires dimensionSpec");
        DelimitedParseSpec spec = new DelimitedParseSpec(new TimestampSpec("timestamp", "auto", null), null, ",", null, Arrays.asList("a", "B"), false, 0);
    }

    @Test
    public void testSerde() throws IOException {
        String json = "{\"format\":\"timeAndDims\", \"timestampSpec\": {\"column\":\"timestamp\"}, \"dimensionsSpec\":{}}";
        Object mapValue = this.mapper.readValue("{\"format\":\"timeAndDims\", \"timestampSpec\": {\"column\":\"timestamp\"}, \"dimensionsSpec\":{}}", JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        ParseSpec parseSpec = (ParseSpec)this.mapper.convertValue(mapValue, ParseSpec.class);
        Assert.assertEquals(TimeAndDimsParseSpec.class, parseSpec.getClass());
        Assert.assertEquals((Object)"timestamp", (Object)parseSpec.getTimestampSpec().getTimestampColumn());
        Assert.assertEquals((Object)ImmutableList.of(), (Object)parseSpec.getDimensionsSpec().getDimensionNames());
        Assert.assertEquals((Object)parseSpec, (Object)this.mapper.readValue(this.mapper.writeValueAsString((Object)parseSpec), ParseSpec.class));
    }

    @Test
    public void testBadTypeSerde() throws IOException {
        String json = "{\"format\":\"foo\", \"timestampSpec\": {\"column\":\"timestamp\"}, \"dimensionsSpec\":{}}";
        Object mapValue = this.mapper.readValue("{\"format\":\"foo\", \"timestampSpec\": {\"column\":\"timestamp\"}, \"dimensionsSpec\":{}}", JacksonUtils.TYPE_REFERENCE_MAP_STRING_OBJECT);
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectCause(CoreMatchers.instanceOf(JsonMappingException.class));
        this.expectedException.expectMessage("Could not resolve type id 'foo' as a subtype");
        this.mapper.convertValue(mapValue, ParseSpec.class);
    }
}

