/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.NoopInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimeAndDimsParseSpec;
import org.junit.Assert;
import org.junit.Test;

public class NoopInputRowParserTest {
    private final ObjectMapper mapper = new ObjectMapper();

    @Test
    public void testSerdeWithNullParseSpec() throws Exception {
        String jsonStr = "{ \"type\":\"noop\" }";
        InputRowParser actual = (InputRowParser)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, InputRowParser.class)), InputRowParser.class);
        Assert.assertEquals((Object)new NoopInputRowParser(null), (Object)actual);
    }

    @Test
    public void testSerdeWithNonNullParseSpec() throws Exception {
        String jsonStr = "{\"type\":\"noop\",\"parseSpec\":{ \"format\":\"timeAndDims\", \"dimensionsSpec\": { \"dimensions\": [\"host\"] } }}";
        InputRowParser actual = (InputRowParser)this.mapper.readValue(this.mapper.writeValueAsString(this.mapper.readValue(jsonStr, InputRowParser.class)), InputRowParser.class);
        Assert.assertEquals((Object)new NoopInputRowParser((ParseSpec)new TimeAndDimsParseSpec(null, new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"host")), null, null))), (Object)actual);
    }
}

