/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.InjectableValues;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableMap;
import org.apache.hive.druid.org.apache.druid.TestObjectMapper;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.JavaScriptParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.Parser;
import org.apache.hive.druid.org.apache.druid.js.JavaScriptConfig;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class JavaScriptParseSpecTest {
    private final ObjectMapper jsonMapper = new TestObjectMapper();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void testSerde() throws IOException {
        this.jsonMapper.setInjectableValues((InjectableValues)new InjectableValues.Std().addValue(JavaScriptConfig.class, (Object)JavaScriptConfig.getEnabledInstance()));
        JavaScriptParseSpec spec = new JavaScriptParseSpec(new TimestampSpec("abc", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Collections.singletonList("abc")), null, null), "abc", JavaScriptConfig.getEnabledInstance());
        JavaScriptParseSpec serde = (JavaScriptParseSpec)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString((Object)spec), ParseSpec.class);
        Assert.assertEquals((Object)"abc", (Object)serde.getTimestampSpec().getTimestampColumn());
        Assert.assertEquals((Object)"iso", (Object)serde.getTimestampSpec().getTimestampFormat());
        Assert.assertEquals((Object)"abc", (Object)serde.getFunction());
        Assert.assertEquals(Collections.singletonList("abc"), (Object)serde.getDimensionsSpec().getDimensionNames());
    }

    @Test
    public void testMakeParser() {
        JavaScriptConfig config = JavaScriptConfig.getEnabledInstance();
        JavaScriptParseSpec spec = new JavaScriptParseSpec(new TimestampSpec("abc", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Collections.singletonList("abc")), null, null), "function(str) { var parts = str.split(\"-\"); return { one: parts[0], two: parts[1] } }", config);
        Parser parser = spec.makeParser();
        Map obj = parser.parseToMap("x-y");
        Assert.assertEquals((Object)ImmutableMap.of((Object)"one", (Object)"x", (Object)"two", (Object)"y"), (Object)obj);
    }

    @Test
    public void testMakeParserNotAllowed() {
        JavaScriptConfig config = new JavaScriptConfig(false);
        JavaScriptParseSpec spec = new JavaScriptParseSpec(new TimestampSpec("abc", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas(Collections.singletonList("abc")), null, null), "abc", config);
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("JavaScript is disabled");
        spec.makeParser();
    }
}

