/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.TestObjectMapper;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.junit.Assert;
import org.junit.Test;

public class JSONPathSpecTest {
    private final ObjectMapper jsonMapper = new TestObjectMapper();

    @Test
    public void testSerde() throws IOException {
        ArrayList<JSONPathFieldSpec> fields = new ArrayList<JSONPathFieldSpec>();
        fields.add(JSONPathFieldSpec.createNestedField((String)"foobar1", (String)"$.foo.bar1"));
        fields.add(JSONPathFieldSpec.createNestedField((String)"baz0", (String)"$.baz[0]"));
        fields.add(JSONPathFieldSpec.createNestedField((String)"hey0barx", (String)"$.hey[0].barx"));
        fields.add(JSONPathFieldSpec.createRootField((String)"timestamp"));
        fields.add(JSONPathFieldSpec.createRootField((String)"foo.bar1"));
        fields.add(JSONPathFieldSpec.createJqField((String)"foobar1", (String)".foo.bar1"));
        fields.add(JSONPathFieldSpec.createJqField((String)"baz0", (String)".baz[0]"));
        fields.add(JSONPathFieldSpec.createJqField((String)"hey0barx", (String)".hey[0].barx"));
        JSONPathSpec flattenSpec = new JSONPathSpec(Boolean.valueOf(true), fields);
        JSONPathSpec serde = (JSONPathSpec)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString((Object)flattenSpec), JSONPathSpec.class);
        Assert.assertTrue((boolean)serde.isUseFieldDiscovery());
        List serdeFields = serde.getFields();
        JSONPathFieldSpec foobar1 = (JSONPathFieldSpec)serdeFields.get(0);
        JSONPathFieldSpec baz0 = (JSONPathFieldSpec)serdeFields.get(1);
        JSONPathFieldSpec hey0barx = (JSONPathFieldSpec)serdeFields.get(2);
        JSONPathFieldSpec timestamp = (JSONPathFieldSpec)serdeFields.get(3);
        JSONPathFieldSpec foodotbar1 = (JSONPathFieldSpec)serdeFields.get(4);
        JSONPathFieldSpec jqFoobar1 = (JSONPathFieldSpec)serdeFields.get(5);
        JSONPathFieldSpec jqBaz0 = (JSONPathFieldSpec)serdeFields.get(6);
        JSONPathFieldSpec jqHey0barx = (JSONPathFieldSpec)serdeFields.get(7);
        Assert.assertEquals((Object)JSONPathFieldType.PATH, (Object)foobar1.getType());
        Assert.assertEquals((Object)"foobar1", (Object)foobar1.getName());
        Assert.assertEquals((Object)"$.foo.bar1", (Object)foobar1.getExpr());
        Assert.assertEquals((Object)JSONPathFieldType.PATH, (Object)baz0.getType());
        Assert.assertEquals((Object)"baz0", (Object)baz0.getName());
        Assert.assertEquals((Object)"$.baz[0]", (Object)baz0.getExpr());
        Assert.assertEquals((Object)JSONPathFieldType.PATH, (Object)hey0barx.getType());
        Assert.assertEquals((Object)"hey0barx", (Object)hey0barx.getName());
        Assert.assertEquals((Object)"$.hey[0].barx", (Object)hey0barx.getExpr());
        Assert.assertEquals((Object)JSONPathFieldType.JQ, (Object)jqFoobar1.getType());
        Assert.assertEquals((Object)"foobar1", (Object)jqFoobar1.getName());
        Assert.assertEquals((Object)".foo.bar1", (Object)jqFoobar1.getExpr());
        Assert.assertEquals((Object)JSONPathFieldType.JQ, (Object)jqBaz0.getType());
        Assert.assertEquals((Object)"baz0", (Object)jqBaz0.getName());
        Assert.assertEquals((Object)".baz[0]", (Object)jqBaz0.getExpr());
        Assert.assertEquals((Object)JSONPathFieldType.JQ, (Object)jqHey0barx.getType());
        Assert.assertEquals((Object)"hey0barx", (Object)jqHey0barx.getName());
        Assert.assertEquals((Object)".hey[0].barx", (Object)jqHey0barx.getExpr());
        Assert.assertEquals((Object)JSONPathFieldType.ROOT, (Object)timestamp.getType());
        Assert.assertEquals((Object)"timestamp", (Object)timestamp.getName());
        Assert.assertEquals((Object)"timestamp", (Object)timestamp.getExpr());
        Assert.assertEquals((Object)JSONPathFieldType.ROOT, (Object)foodotbar1.getType());
        Assert.assertEquals((Object)"foo.bar1", (Object)foodotbar1.getName());
        Assert.assertEquals((Object)"foo.bar1", (Object)foodotbar1.getExpr());
    }
}

