/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.TestObjectMapper;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.JSONParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.JSONPathFieldSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.JSONPathFieldType;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.Parser;
import org.junit.Assert;
import org.junit.Test;

public class JSONParseSpecTest {
    private final ObjectMapper jsonMapper = new TestObjectMapper();

    @Test
    public void testParseRow() {
        JSONParseSpec parseSpec = new JSONParseSpec(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo")), null, null), new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz", "baz"), (Object)new JSONPathFieldSpec(JSONPathFieldType.ROOT, "root_baz2", "baz2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg", "$.o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "path_omg2", "$.o.mg2"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg", ".o.mg"), (Object)new JSONPathFieldSpec(JSONPathFieldType.JQ, "jq_omg2", ".o.mg2"))), null);
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("foo", "x");
        expected.put("baz", 4L);
        expected.put("root_baz", 4L);
        expected.put("root_baz2", null);
        expected.put("path_omg", 1L);
        expected.put("path_omg2", null);
        expected.put("jq_omg", 1L);
        expected.put("jq_omg2", null);
        Parser parser = parseSpec.makeParser();
        Map parsedRow = parser.parseToMap("{\"bar\":null,\"foo\":\"x\",\"baz\":4,\"o\":{\"mg\":1}}");
        Assert.assertNotNull((Object)parsedRow);
        Assert.assertEquals(expected, (Object)parsedRow);
        Assert.assertNull(parsedRow.get("bar"));
        Assert.assertNull(parsedRow.get("buzz"));
        Assert.assertNull(parsedRow.get("root_baz2"));
        Assert.assertNull(parsedRow.get("jq_omg2"));
        Assert.assertNull(parsedRow.get("path_omg2"));
    }

    @Test
    public void testParseRowWithConditional() {
        JSONParseSpec parseSpec = new JSONParseSpec(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"foo")), null, null), new JSONPathSpec(Boolean.valueOf(true), (List)ImmutableList.of((Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "foo", "$.[?(@.maybe_object)].maybe_object.foo.test"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "baz", "$.maybe_object_2.foo.test"), (Object)new JSONPathFieldSpec(JSONPathFieldType.PATH, "bar", "$.[?(@.something_else)].something_else.foo"))), null);
        HashMap<String, List<Object>> expected = new HashMap<String, List<Object>>();
        expected.put("foo", new ArrayList());
        expected.put("baz", null);
        expected.put("bar", Collections.singletonList("test"));
        Parser parser = parseSpec.makeParser();
        Map parsedRow = parser.parseToMap("{\"something_else\": {\"foo\": \"test\"}}");
        Assert.assertNotNull((Object)parsedRow);
        Assert.assertEquals(expected, (Object)parsedRow);
    }

    @Test
    public void testSerde() throws IOException {
        HashMap<String, Boolean> feature = new HashMap<String, Boolean>();
        feature.put("ALLOW_UNQUOTED_CONTROL_CHARS", true);
        JSONParseSpec spec = new JSONParseSpec(new TimestampSpec("timestamp", "iso", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"bar", (Object)"foo")), null, null), null, feature);
        JSONParseSpec serde = (JSONParseSpec)this.jsonMapper.readValue(this.jsonMapper.writeValueAsString((Object)spec), ParseSpec.class);
        Assert.assertEquals((Object)"timestamp", (Object)serde.getTimestampSpec().getTimestampColumn());
        Assert.assertEquals((Object)"iso", (Object)serde.getTimestampSpec().getTimestampFormat());
        Assert.assertEquals(Arrays.asList("bar", "foo"), (Object)serde.getDimensionsSpec().getDimensionNames());
        Assert.assertEquals(feature, (Object)serde.getFeatureSpec());
    }
}

