/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.com.google.common.collect.Iterables;
import org.apache.hive.druid.org.apache.druid.data.input.InputFormat;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.InputRowSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.CsvInputFormat;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.FileEntity;
import org.apache.hive.druid.org.apache.druid.data.input.impl.InputEntityIteratingReader;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.hive.druid.org.apache.druid.java.util.common.DateTimes;
import org.apache.hive.druid.org.apache.druid.java.util.common.StringUtils;
import org.apache.hive.druid.org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class InputEntityIteratingReaderTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void test() throws IOException {
        int numFiles = 5;
        ArrayList<File> files = new ArrayList<File>();
        for (int i = 0; i < 5; ++i) {
            File file2 = this.temporaryFolder.newFile("test_" + i);
            files.add(file2);
            try (BufferedWriter writer = Files.newBufferedWriter(file2.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                writer.write(StringUtils.format((String)"%d,%s,%d\n", (Object[])new Object[]{20190101 + i, "name_" + i, i}));
                writer.write(StringUtils.format((String)"%d,%s,%d", (Object[])new Object[]{20190102 + i, "name_" + (i + 1), i + 1}));
                continue;
            }
        }
        InputEntityIteratingReader firehose = new InputEntityIteratingReader(new InputRowSchema(new TimestampSpec("time", "yyyyMMdd", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"time", (Object)"name", (Object)"score"))), Collections.emptyList()), (InputFormat)new CsvInputFormat((List)ImmutableList.of((Object)"time", (Object)"name", (Object)"score"), null, null, Boolean.valueOf(false), 0), files.stream().flatMap(file -> ImmutableList.of((Object)new FileEntity(file)).stream()), this.temporaryFolder.newFolder());
        try (CloseableIterator iterator = firehose.read();){
            int i = 0;
            while (iterator.hasNext()) {
                InputRow row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-%02d", (Object[])new Object[]{i + 1})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{i}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                Assert.assertEquals((Object)Integer.toString(i), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("score")));
                Assert.assertTrue((boolean)iterator.hasNext());
                row = (InputRow)iterator.next();
                Assert.assertEquals((Object)DateTimes.of((String)StringUtils.format((String)"2019-01-%02d", (Object[])new Object[]{i + 2})), (Object)row.getTimestamp());
                Assert.assertEquals((Object)StringUtils.format((String)"name_%d", (Object[])new Object[]{i + 1}), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("name")));
                Assert.assertEquals((Object)Integer.toString(i + 1), (Object)Iterables.getOnlyElement((Iterable)row.getDimension("score")));
                ++i;
            }
            Assert.assertEquals((long)5L, (long)i);
        }
    }
}

