/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.io.LineIterator;
import org.apache.hive.druid.com.google.common.base.Joiner;
import org.apache.hive.druid.com.google.common.collect.ImmutableList;
import org.apache.hive.druid.org.apache.druid.data.input.InputRow;
import org.apache.hive.druid.org.apache.druid.data.input.impl.CSVParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.FileIteratingFirehose;
import org.apache.hive.druid.org.apache.druid.data.input.impl.ParseSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringInputRowParser;
import org.apache.hive.druid.org.apache.druid.data.input.impl.TimestampSpec;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FileIteratingFirehoseTest {
    private static final char[] LINE_CHARS = "\n".toCharArray();
    private final StringInputRowParser parser;
    private final List<String> inputs;
    private final List<String> expectedResults;

    @Parameterized.Parameters(name="{0}, {1}")
    public static Collection<Object[]> constructorFeeder() {
        ImmutableList inputTexts = ImmutableList.of((Object)ImmutableList.of((Object)"2000,foo"), (Object)ImmutableList.of((Object)"2000,foo\n2000,bar\n"), (Object)ImmutableList.of((Object)"2000,foo\n2000,bar\n", (Object)"2000,baz"), (Object)ImmutableList.of((Object)"2000,foo\n2000,bar\n", (Object)"", (Object)"2000,baz"), (Object)ImmutableList.of((Object)"2000,foo\n2000,bar\n", (Object)"", (Object)"2000,baz", (Object)""), (Object)ImmutableList.of((Object)"2000,foo\n2000,bar\n2000,baz", (Object)"", (Object)"2000,baz", (Object)"2000,foo\n2000,bar\n3000,baz"), (Object)ImmutableList.of((Object)""), (Object)ImmutableList.of());
        ArrayList<Object[]> args = new ArrayList<Object[]>();
        for (int numSkipHeadRows = 0; numSkipHeadRows < 3; ++numSkipHeadRows) {
            for (List texts : inputTexts) {
                args.add(new Object[]{texts, numSkipHeadRows});
            }
        }
        return args;
    }

    public FileIteratingFirehoseTest(List<String> texts, int numSkipHeaderRows) {
        this.parser = new StringInputRowParser((ParseSpec)new CSVParseSpec(new TimestampSpec("ts", "auto", null), new DimensionsSpec(DimensionsSpec.getDefaultSchemas((List)ImmutableList.of((Object)"x")), null, null), ",", (List)ImmutableList.of((Object)"ts", (Object)"x"), false, numSkipHeaderRows), null);
        this.inputs = texts;
        this.expectedResults = this.inputs.stream().map(input -> input.split("\n")).flatMap(lines -> {
            List filteredLines = Arrays.stream(lines).filter(line -> line.length() > 0).map(line -> line.split(",")[1]).collect(Collectors.toList());
            int numRealSkippedRows = Math.min(filteredLines.size(), numSkipHeaderRows);
            IntStream.range(0, numRealSkippedRows).forEach(i -> {
                String cfr_ignored_0 = filteredLines.set(i, null);
            });
            return filteredLines.stream();
        }).collect(Collectors.toList());
    }

    @Test
    public void testFirehose() throws Exception {
        List lineIterators = this.inputs.stream().map(s -> new LineIterator((Reader)new StringReader((String)s))).collect(Collectors.toList());
        try (FileIteratingFirehose firehose = new FileIteratingFirehose(lineIterators.iterator(), this.parser);){
            ArrayList<String> results = new ArrayList<String>();
            while (firehose.hasMore()) {
                InputRow inputRow = firehose.nextRow();
                if (inputRow == null) {
                    results.add(null);
                    continue;
                }
                results.add(Joiner.on((String)"|").join((Iterable)inputRow.getDimension("x")));
            }
            Assert.assertEquals(this.expectedResults, results);
        }
    }

    @Test(expected=RuntimeException.class)
    public void testClose() throws IOException {
        LineIterator lineIterator = new LineIterator(new Reader(){

            @Override
            public int read(char[] cbuf, int off, int len) {
                System.arraycopy(LINE_CHARS, 0, cbuf, 0, LINE_CHARS.length);
                return LINE_CHARS.length;
            }

            @Override
            public void close() {
                throw new RuntimeException("close test for FileIteratingFirehose");
            }
        });
        TestCloseable closeable = new TestCloseable();
        FileIteratingFirehose firehose = new FileIteratingFirehose((Iterator)ImmutableList.of((Object)lineIterator).iterator(), this.parser, (Closeable)closeable);
        firehose.hasMore();
        firehose.close();
        Assert.assertTrue((boolean)closeable.closed);
    }

    private static final class TestCloseable
    implements Closeable {
        private boolean closed;

        private TestCloseable() {
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

