/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.druid.org.apache.druid.data.input.impl;

import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.apache.hive.druid.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.hive.druid.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hive.druid.org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.hive.druid.org.apache.druid.data.input.impl.FloatDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.LongDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.NewSpatialDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.SpatialDimensionSchema;
import org.apache.hive.druid.org.apache.druid.data.input.impl.StringDimensionSchema;
import org.junit.Test;

public class DimensionsSpecSerdeTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Test
    public void testDimensionsSpecSerde() throws Exception {
        DimensionsSpec expected = new DimensionsSpec(Arrays.asList(new StringDimensionSchema("AAA"), new StringDimensionSchema("BBB"), new FloatDimensionSchema("C++"), new NewSpatialDimensionSchema("DDT", null), new LongDimensionSchema("EEE"), new NewSpatialDimensionSchema("DDT2", Arrays.asList("A", "B")), new NewSpatialDimensionSchema("IMPR", Arrays.asList("S", "P", "Q", "R"))), Arrays.asList("FOO", "HAR"), null);
        String jsonStr = "{\"dimensions\":[\"AAA\", \"BBB\",{\"name\":\"C++\", \"type\":\"float\"},{\"name\":\"DDT\", \"type\":\"spatial\"},{\"name\":\"EEE\", \"type\":\"long\"},{\"name\":\"DDT2\", \"type\": \"spatial\", \"dims\":[\"A\", \"B\"]}],\"dimensionExclusions\": [\"FOO\", \"HAR\"],\"spatialDimensions\": [{\"dimName\":\"IMPR\", \"dims\":[\"S\",\"P\",\"Q\",\"R\"]}]}";
        DimensionsSpec actual = (DimensionsSpec)OBJECT_MAPPER.readValue(OBJECT_MAPPER.writeValueAsString(OBJECT_MAPPER.readValue(jsonStr, DimensionsSpec.class)), DimensionsSpec.class);
        List<SpatialDimensionSchema> expectedSpatials = Arrays.asList(new SpatialDimensionSchema("DDT", null), new SpatialDimensionSchema("DDT2", Arrays.asList("A", "B")), new SpatialDimensionSchema("IMPR", Arrays.asList("S", "P", "Q", "R")));
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertEquals(expectedSpatials, (Object)actual.getSpatialDimensions());
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

